/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util;

import com.fshows.component.ISignBlock;
import com.fshows.util.SM2Util;
import com.fshows.util.SM4Utils;
import com.fshows.util.StringUtil;
import com.fshows.util.Utils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.bouncycastle.crypto.digests.SM3Digest;

public class SMSaltSigner {
    private static final int KEY_LEN = 32;

    public String genKey() {
        return Base64.getEncoder().encodeToString(StringUtil.genRandomByte(32));
    }

    public String sign(ISignBlock signBlock, String key) {
        String input = signBlock.getSignBlock();
        String dataWithSalt = input + key;
        System.out.println(dataWithSalt);
        byte[] srcByte = dataWithSalt.getBytes(StandardCharsets.UTF_8);
        byte[] md = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.update(srcByte, 0, srcByte.length);
        sm3.doFinal(md, 0);
        String ret = Base64.getEncoder().encodeToString(md);
        return ret;
    }

    public static void main(String[] args) {
        String dataWithSalt = "/payGateway/payApi/merchant/getSm4Key&{\"isRefresh\":0}&M00014823&20230831163311FSuURpSNfUZhYz+T3woAwqkMqaHtWRotdtw4/Lj+yiI=";
        System.out.println(dataWithSalt);
        byte[] srcByte = dataWithSalt.getBytes(StandardCharsets.UTF_8);
        byte[] md = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.update(srcByte, 0, srcByte.length);
        sm3.doFinal(md, 0);
        String ret = Base64.getEncoder().encodeToString(md);
        System.out.println(ret);
    }

    public boolean verify(ISignBlock signBlock, String sign, String key) {
        String sign2 = this.sign(signBlock, key);
        if (StringUtil.stringIsNull(sign2)) {
            return false;
        }
        return sign2.equals(sign);
    }

    public String encryptData(String secretKey, String plainText) {
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = secretKey;
        sm4.hexString = true;
        String cipherText = sm4.encryptData_ECB(plainText);
        return cipherText;
    }

    public String decryptData(String secretKey, String cipherText) {
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = secretKey;
        sm4.hexString = true;
        String plainText = sm4.decryptData_ECB(cipherText);
        return plainText;
    }

    public String decryptSm2(String secretKey, String cipherText) {
        SM2Util sm2 = new SM2Util();
        byte[] aa = Utils.hexStringToBytes(cipherText);
        String deData = sm2.decrypt(aa, secretKey);
        return deData;
    }
}

