/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.util;

import com.fshows.util.SM4;
import com.fshows.util.SM4Context;
import com.fshows.util.Utils;
import java.io.IOException;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SM4Utils {
    public String secretKey = "";
    public String iv = "";
    public boolean hexString = false;

    public String encryptData_ECB(String plainText) {
        try {
            System.out.println("\u8bf7\u6c42\u660e\u6587" + plainText);
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = this.hexString ? Utils.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes("GBK"));
            String cipherText = Base64.getEncoder().encodeToString(encrypted);
            System.out.println("\u52a0\u5bc6\u5bc6\u6587" + cipherText);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_ECB(String cipherText) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = this.hexString ? Utils.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, Base64.getDecoder().decode(cipherText));
            return new String(decrypted, "GBK");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encryptData_CBC(String plainText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (this.hexString) {
                keyBytes = Utils.hexStringToBytes(this.secretKey);
                ivBytes = Utils.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainText.getBytes("GBK"));
            String cipherText = Base64.getEncoder().encodeToString(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_CBC(String cipherText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (this.hexString) {
                keyBytes = Utils.hexStringToBytes(this.secretKey);
                ivBytes = Utils.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.getDecoder().decode(cipherText));
            return new String(decrypted, "GBK");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        String plainText = "{\"outTradeNo\":\"47232f16-ffb9-4813-addd-5d1779b9ddfa\",\"merchantNo\":\"M00019234\"}";
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = "D6680DAF9786E65B06AE00A9CEF5E3E1";
        System.out.println(sm4.secretKey);
        sm4.hexString = true;
        System.out.println("ECB\u6a21\u5f0f\u52a0\u5bc6");
        String cipherText = sm4.encryptData_ECB(plainText);
        System.out.println("\u5bc6\u6587: " + cipherText);
        plainText = sm4.decryptData_ECB(cipherText);
        System.out.println("\u660e\u6587: " + plainText);
        System.out.println("");
    }
}

