/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.component;

import com.fshows.component.BodySignBlock;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.handler.IApiSignHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.util.SMSaltSigner;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sm3ApiSignHandler
implements IApiSignHandler {
    private static final Logger log = LoggerFactory.getLogger(Sm3ApiSignHandler.class);
    private SMSaltSigner signer = new SMSaltSigner();
    private static final String WITH = "&";

    public String sign(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        Object waitSignStr = null;
        try {
            DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
            IApiDefinition apiDefinition = requestContext.getIApiDefinition();
            Map headMap = apiRequestModel.getHeadMap();
            String timestamp = (String)headMap.get("Time-Stamp");
            BodySignBlock signBlock = new BodySignBlock(apiDefinition.getApiURI(), apiClientConfig.getAppId(), timestamp, apiRequestModel.getRequestBody());
            return this.signer.sign(signBlock, apiClientConfig.getMd5SignKey());
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25 >> apiRequestModel={}, waitSignStr={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel, waitSignStr});
            throw new FsApiException("\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25", (Throwable)e);
        }
    }

    public Boolean verifySign(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext defaultRequestContext) {
        return Boolean.TRUE;
    }
}

