/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.utils.wrapper;

/**
 * 项目：lifecircle-service-utils
 * 包名：com.fshows.lifecircle.service.utils.wrapper
 * 功能：
 * 创建时间：2018-01-03 19:32
 * 更新记录：
 * @author BuHao
 */

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import jodd.io.StreamUtil;

/**
 * 项目：lifecircle-service-app-merchant
 * 包名：com.fshows.lifecircle.app.merchant.service.web.filter
 * 功能：可复用的request 对象封装类
 * 创建时间：2018-01-03 11:55
 * 更新记录：
 *
 * @author BuHao
 */
public class ReuseHttpServletRequestWrapper extends HttpServletRequestWrapper {

  private final byte[] body;

  public ReuseHttpServletRequestWrapper(HttpServletRequest request)
      throws IOException {
    super(request);
    body = StreamUtil.readBytes(request.getReader(), "UTF-8");
  }

  @Override
  public BufferedReader getReader() throws IOException {
    return new BufferedReader(new InputStreamReader(getInputStream()));
  }

  @Override
  public ServletInputStream getInputStream() throws IOException {
    final ByteArrayInputStream bais = new ByteArrayInputStream(body);
    return new ServletInputStream() {

      @Override
      public int read() throws IOException {
        return bais.read();
      }

      @Override
      public boolean isFinished() {
        return false;
      }

      @Override
      public boolean isReady() {
        return false;
      }

      @Override
      public void setReadListener(ReadListener arg0) {
      }
    };
  }

}
