/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.utils.domain;

import com.fshows.lifecircle.service.utils.CollectionUtils;

import java.util.List;

/**
 * 项目：lifecircle-business-advertising
 * 包名：com.fshows.lifecircle.business.advertising.openapi.facade.domain.result
 * 功能：
 * 创建时间：2017-10-19 18:36
 * 更新记录：
 *
 * @author：BuHao
 */
public class PageResult<T> {

    private Integer totalNum;
    private List<T> data;

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public List<T> getData() {
        return data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public PageResult(Integer totalNum, List<T> data) {
        this.totalNum = totalNum;
        this.data = CollectionUtils.safe(data);
    }

    @Override
    public String toString() {
        return "PageResult{" +
                "totalNum=" + totalNum +
                ", data=" + data +
                '}';
    }
}
