package com.fshows.lifecircle.service.utils.domain;

/**
 * 项目：lifecircle-service-advertising
 * 包名：com.fshows.lifecircle.service.advertising.openapi.facade.domain.result
 * 功能：
 * 创建时间：2017-09-28 11:01
 * 更新记录：
 *
 * @author ：BuHao
 */
public enum ErrorCode {

  /**
   * 数据操作失败
   */
  DATA_OPERATION_FAILURE("DATA_OPERATION_FAILURE", 405),
  /**
   * 无效参数
   */
  INVALID_PARAMETER("INVALID_PARAMETER", 401),
  /**
   * RPC 服务器错误
   */
  SERVER_RPC_ERROR("SERVER_RPC_ERROR [501]", 501),
  /**
   * 服务配置错误
   */
  SERVER_CONFIG_ERROR("SERVER_CONFIG_ERROR [502]", 502),
  /**
   * 请求方法错误
   */
  REQUEST_METHOD_ERROR("REQUEST_METHOD_ERROR", 402),
  /**
   * 媒体类型不支持
   */
  MEDIA_NOT_SUPPORT_ERROR("MEDIA_NOT_SUPPORT_ERROR", 403),
  /**
   * 登录失效
   */
  LOGIN_FAILURE("LOGIN_FAILURE", 406),
  /**
   * 签名错误
   */
  SIGN_ERROR("SIGN_ERROR", 407),
  /**
   * 权限不足
   */
  PERMISSION_DENIED("PERMISSION_DENIED", 408),
  /**
   * 地址错误
   */
  PATH_NOT_FOUND("PATH_NOT_FOUND", 404);

  private String msg;
  private Integer value;

  ErrorCode(String msg, Integer value) {
    this.msg = msg;
    this.value = value;
  }

  public Integer value() {

    return this.value;
  }

  public String str() {

    return this.msg;
  }
}
