package com.fshows.lifecircle.service.utils.domain;

/**
 * 项目：lifecircle-service-advertise
 * 包名：com.fshows.lifecircle.service.advertise.core.model.result
 * 功能：
 * 创建时间：2017-09-26 15:46
 * 更新记录：
 * @author ：BuHao
 */
public enum ApiResultCode {

  /**
   * 调用成功
   */
  SUCCESS(200),
  /*
  * 客户端错误
  */
  CLIENT_FAILURE(400),
  /**
   * 服务端失败
   */
  SERVER_FAILURE(500);

  private Integer value = 500;

  ApiResultCode(Integer val) {

    this.value = val;
  }

  public Integer value() {

    return this.value;
  }

  public String str() {

    String name = this.name();
    if (name.equals(SUCCESS.name())) {

      return "请求成功";
    } else if (name.equals(CLIENT_FAILURE.name())) {

      return "客户端错误";
    } else {

      return "服务端错误";
    }
  }

  public static void main(String[] args) {

    System.out.println(ApiResultCode.SUCCESS.str());

  }
}
