package com.fshows.lifecircle.service.utils;

import com.fshows.lifecircle.service.utils.domain.ValidateResult;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import java.util.Set;

import static com.google.common.collect.Iterables.getFirst;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.utils
 * @description：描述
 * @updateDesription：更新记录描述
 * @date：2018/2/1
 * @author：Wendy
 */
public class ValidateUtils {
    public static <T> ValidateResult validate(T object) {

        ValidateResult validateResult = new ValidateResult();
        validateResult.setSuccess(true);
        validateResult.setMsg("验证成功！");

        //获得验证器
        Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        //执行验证
        Set<ConstraintViolation<T>> constraintViolations = validator.validate(object);
        //如果有验证信息，则将第一个取出来包装成异常返回
        ConstraintViolation<T> constraintViolation = getFirst(constraintViolations, null);
        if (constraintViolation != null) {

            validateResult.setSuccess(false);
            validateResult.setMsg("[" + constraintViolation.getPropertyPath() + "]" + constraintViolation.getMessage());
        }

        return validateResult;
    }

}
