package com.fshows.lifecircle.service.utils;

import lombok.extern.slf4j.Slf4j;

import java.util.ResourceBundle;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.utils
 * @description：描述:读取配置文件
 * @updateDesription：更新记录描述
 * @date：2018/2/1
 * @author：Wendy
 */
@Slf4j
public class ResourceUtil {

    public static ResourceBundle getSystem(final String path) {
        ResourceBundle system = null;
        try {
            system = ResourceBundle.getBundle(path);
        } catch (Exception e) {
            log.error("ResourceUtil -- >> systemConfig.properties Not Found. some keys lost.");
        }
        if (system == null) {
            log.error("ResourceUtil -- >> systemConfig.properties Not Found. some keys lost.");
        }
        return system;
    }

    public static String getSystem(final String path, final String key) {
        String msg = null;
        ResourceBundle system;
        system  = getSystem(path);
        try {
            msg = system.getString(key);
        } catch (Exception e) {
            log.error("ResourceUtil -- >>  Key['" + key + "'] Not Found in systemConfig.properties .");
        }
        return msg == null ? system.getString("default") : msg;
    }
}
