/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

/**
 * 项目：study4j
 * 包名：cn.coder4j.study4j
 * 功能：
 * 创建时间：2018-04-10 16:30
 * 更新记录：
 *
 * @author BuHao
 */
public class MyQRCodeUtil {

  // 默认二维码文件格式
  private static final String FORMAT = "png";
  // 二维码参数
  private static final Map<EncodeHintType, Object> HINTS = new HashMap<>();

  static {
    // 字符编码
    HINTS.put(EncodeHintType.CHARACTER_SET, "utf-8");
    // 容错等级 L、M、Q、H 其中 L 为最低, H 为最高
    HINTS.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
    // 二维码与图片边距
    HINTS.put(EncodeHintType.MARGIN, 0);
  }

  /**
   * 返回一个 BufferedImage 对象
   *
   * @param content 二维码内容
   * @param width 宽
   * @param height 高
   */
  public static BufferedImage toBufferedImage(String content, int width, int height)
      throws WriterException, IOException {
    BitMatrix bitMatrix = new MultiFormatWriter()
        .encode(content, BarcodeFormat.QR_CODE, width, height,
            HINTS);
    return MatrixToImageWriter.toBufferedImage(bitMatrix);
  }

  /**
   * 将二维码图片输出到一个流中
   *
   * @param content 二维码内容
   * @param stream 输出流
   * @param width 宽
   * @param height 高
   */
  public static void writeToStream(String content, OutputStream stream, int width, int height)
      throws WriterException, IOException {
    BitMatrix bitMatrix = new MultiFormatWriter()
        .encode(content, BarcodeFormat.QR_CODE, width, height,
            HINTS);
    MatrixToImageWriter.writeToStream(bitMatrix, FORMAT, stream);
  }

  /**
   * 生成二维码图片文件
   *
   * @param content 二维码内容
   * @param path 文件保存路径
   * @param width 宽
   * @param height 高
   */
  public static void createQRCode(String content, String path, int width, int height)
      throws WriterException, IOException {
    BitMatrix bitMatrix = new MultiFormatWriter()
        .encode(content, BarcodeFormat.QR_CODE, width, height,
            HINTS);
    //toPath() 方法由 jdk1.7 及以上提供
    MatrixToImageWriter.writeToPath(bitMatrix, FORMAT, new File(path).toPath());
  }
}
