/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.utils;


import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.RandomUtil;
import lombok.experimental.UtilityClass;

/**
 * 项目：lifecircle-service-user
 * 包名：com.fshows.lifecircle.user.service.business.utils
 * 功能：主键生成工具类
 * 创建时间：2017-12-04 21:57
 * 更新记录：
 *
 * @author BuHao
 */
@UtilityClass
public class KeyGenerator {


  /**
   * <p>根据类型获得主键 key</p>
   *
   * @param keyTypeEnum 主键类型
   */
  public Long getKeyByType(KeyTypeEnum keyTypeEnum) {

    String s = RandomUtil.randomNumbers(6);

    if (keyTypeEnum == null) {

      return getKeyByType();
    }

    return Long.valueOf(new DateTime().toString("yyMMddHHmm") + keyTypeEnum.valueOf() + s);
  }

  /**
   * <p>获得通用的主键</p>
   * @return
   */
  public Long getKeyByType() {

    String s = RandomUtil.randomNumbers(6);

    return Long.valueOf(s);
  }
}
