package com.fshows.lifecircle.service.utils;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GetObjectRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import lombok.extern.slf4j.Slf4j;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.service.utils
 * @description：描述:阿里OSS存储Util
 * @updateDesription：更新记录描述
 * @date：2017/12/14
 * @author：Wendy
 */
@Slf4j
public class AliOSSUtil {

  /**
   * 上传文件
   */
  public static boolean uploadFile(String bucketName, String key, String filename,
      OSSClient ossClient) {

    try {
      File file = new File(filename);
      InputStream input = new FileInputStream(file);
      ossClient.putObject(bucketName, key, input);
      //关闭OSSClient
      ossClient.shutdown();
      return true;
    } catch (Exception e) {
      log.error("AliOSSUtil ---- >> uploadFile 上传异常, e = {}", ExceptionUtil.stacktraceToString(e));
      ossClient.shutdown();
      return false;
    }
  }

  /**
   * 下载文件
   */
  public static void downloadFile(String bucketName, String key, String filename,
      OSSClient ossClient) {
    try {
      ossClient.getObject(new GetObjectRequest(bucketName, key), new File(filename));
      //关闭ossClient
      ossClient.shutdown();
    } catch (Exception e) {
      log.error("AliOSSUtil ---- >> downloadFile 下载异常, e = {}", ExceptionUtil.getMessage(e));
      ossClient.shutdown();
    }
  }

  /**
   * 生成下载url get的方式访问
   */
  public static String fileUrl(String bucketName, String key, OSSClient ossClient) {
    String downloadUrl = "";
    try {
      // 设置URL过期时间
      Date time = new Date(System.currentTimeMillis() + 3600 * 1000);
      // 生成URL
      URL url = ossClient.generatePresignedUrl(bucketName, key, time);
      downloadUrl = url.toString();
      //关闭ossClient
      ossClient.shutdown();
      return downloadUrl;
    } catch (Exception e) {
      ossClient.shutdown();
      log.error("AliOSSUtil ---- >> fileUrl 下载地址异常, e = {}", ExceptionUtil.getMessage(e));
      return downloadUrl;
    }
  }


}
