package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 商户子账户角色表
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_user_merchant_children_role")
public class FbUserMerchantChildrenRole implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;

	@TableField("role_id")
	private Long roleId;

    /**
     * 商户ID
     */
	private Long mid;
    /**
     * 角色名称
     */
	private String name;
    /**
     * 备注
     */
	private String remark;
    /**
     * 权限节点
     */
	@TableField("access_list")
	private String accessList;
    /**
     * 是否激活 1：是 0：否
     */
	private Integer status;
    /**
     * 角色类型 1店长 2 收银员 3 服务员
     */
	@TableField("role_type")
	private Integer roleType;
    /**
     * 是否删除 0否 1是
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbUserMerchantChildrenRole setId(Long id) {
		this.id = id;
		return this;
	}


	public Long getRoleId() {
		return roleId;
	}

	public FbUserMerchantChildrenRole setRoleId(Long roleId) {
		this.roleId = roleId;
		return this;
	}

	public Long getMid() {
		return mid;
	}

	public FbUserMerchantChildrenRole setMid(Long mid) {
		this.mid = mid;
		return this;
	}

	public String getName() {
		return name;
	}

	public FbUserMerchantChildrenRole setName(String name) {
		this.name = name;
		return this;
	}

	public String getRemark() {
		return remark;
	}

	public FbUserMerchantChildrenRole setRemark(String remark) {
		this.remark = remark;
		return this;
	}

	public String getAccessList() {
		return accessList;
	}

	public FbUserMerchantChildrenRole setAccessList(String accessList) {
		this.accessList = accessList;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public FbUserMerchantChildrenRole setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Integer getRoleType() {
		return roleType;
	}

	public FbUserMerchantChildrenRole setRoleType(Integer roleType) {
		this.roleType = roleType;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbUserMerchantChildrenRole setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbUserMerchantChildrenRole setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbUserMerchantChildrenRole setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String ROLE_ID = "role_id";

	public static final String MID = "mid";

	public static final String NAME = "name";

	public static final String REMARK = "remark";

	public static final String ACCESS_LIST = "access_list";

	public static final String STATUS = "status";

	public static final String ROLE_TYPE = "role_type";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbUserMerchantChildrenRole{" +
			", id=" + id +
			", mid=" + mid +
			", name=" + name +
			", remark=" + remark +
			", accessList=" + accessList +
			", status=" + status +
			", roleType=" + roleType +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
