package com.fshows.lifecircle.user.service.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 用户基础信息
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
@TableName("fb_user_base")
public class FbUserBase implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Long id;
    /**
     * 旧系统用户ID
     */
	@TableField("o_uid")
	private Integer oUid;
    /**
     * 用户ID
     */
	@TableField("base_id")
	private Long baseId;
    /**
     * 用户类型 1 OEM商 2代理商 3授理商 4商户 
     */
	@TableField("user_type")
	private Integer userType;
    /**
     * 是否子账户 0否 1是
     */
	@TableField("is_child")
	private Integer isChild;
    /**
     * 用户名
     */
	private String username;
    /**
     * 用户密码
     */
	private String userpwd;
    /**
     * 加密密码 盐值
     */
	private String salt;
    /**
     * 用户状态 1 正常 0禁用
     */
	private Integer status;
    /**
     * 手机号
     */
	private String mobile;
    /**
     * QQ
     */
	private String qq;
    /**
     * 电子邮箱
     */
	private String email;
    /**
     * 省份code（gaode）
     */
	@TableField("province_code")
	private String provinceCode;
    /**
     * 省份名称（gaode）
     */
	@TableField("province_name")
	private String provinceName;
    /**
     * 城市code（gaode）
     */
	@TableField("city_code")
	private String cityCode;
    /**
     * 城市名称（gaode）
     */
	@TableField("city_name")
	private String cityName;
    /**
     * 区域code（gaode）
     */
	@TableField("area_code")
	private String areaCode;
    /**
     * 区域名称（gaode）
     */
	@TableField("area_name")
	private String areaName;
    /**
     * 详细地址
     */
	private String address;
    /**
     * 最后一次登录IP
     */
	@TableField("last_login_ip")
	private Long lastLoginIp;
    /**
     * 最后一次登录时间
     */
	@TableField("last_login_time")
	private Date lastLoginTime;
    /**
     * 登录错误次数
     */
	@TableField("login_error_count")
	private Integer loginErrorCount;
    /**
     * 登录锁定时间
     */
	@TableField("login_lock_time")
	private Long loginLockTime;
    /**
     * 平台 1：运营后台
     */
	private Integer platform;
    /**
     * 是否删除 0否 1是
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Long getId() {
		return id;
	}

	public FbUserBase setId(Long id) {
		this.id = id;
		return this;
	}

	public Integer getoUid() {
		return oUid;
	}

	public FbUserBase setoUid(Integer oUid) {
		this.oUid = oUid;
		return this;
	}

	public Long getBaseId() {
		return baseId;
	}

	public FbUserBase setBaseId(Long baseId) {
		this.baseId = baseId;
		return this;
	}

	public Integer getUserType() {
		return userType;
	}

	public FbUserBase setUserType(Integer userType) {
		this.userType = userType;
		return this;
	}

	public Integer getIsChild() {
		return isChild;
	}

	public FbUserBase setIsChild(Integer isChild) {
		this.isChild = isChild;
		return this;
	}

	public String getUsername() {
		return username;
	}

	public FbUserBase setUsername(String username) {
		this.username = username;
		return this;
	}

	public String getUserpwd() {
		return userpwd;
	}

	public FbUserBase setUserpwd(String userpwd) {
		this.userpwd = userpwd;
		return this;
	}

	public String getSalt() {
		return salt;
	}

	public FbUserBase setSalt(String salt) {
		this.salt = salt;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public FbUserBase setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public String getMobile() {
		return mobile;
	}

	public FbUserBase setMobile(String mobile) {
		this.mobile = mobile;
		return this;
	}

	public String getQq() {
		return qq;
	}

	public FbUserBase setQq(String qq) {
		this.qq = qq;
		return this;
	}

	public String getEmail() {
		return email;
	}

	public FbUserBase setEmail(String email) {
		this.email = email;
		return this;
	}

	public String getProvinceCode() {
		return provinceCode;
	}

	public FbUserBase setProvinceCode(String provinceCode) {
		this.provinceCode = provinceCode;
		return this;
	}

	public String getProvinceName() {
		return provinceName;
	}

	public FbUserBase setProvinceName(String provinceName) {
		this.provinceName = provinceName;
		return this;
	}

	public String getCityCode() {
		return cityCode;
	}

	public FbUserBase setCityCode(String cityCode) {
		this.cityCode = cityCode;
		return this;
	}

	public String getCityName() {
		return cityName;
	}

	public FbUserBase setCityName(String cityName) {
		this.cityName = cityName;
		return this;
	}

	public String getAreaCode() {
		return areaCode;
	}

	public FbUserBase setAreaCode(String areaCode) {
		this.areaCode = areaCode;
		return this;
	}

	public String getAreaName() {
		return areaName;
	}

	public FbUserBase setAreaName(String areaName) {
		this.areaName = areaName;
		return this;
	}

	public String getAddress() {
		return address;
	}

	public FbUserBase setAddress(String address) {
		this.address = address;
		return this;
	}

	public Long getLastLoginIp() {
		return lastLoginIp;
	}

	public FbUserBase setLastLoginIp(Long lastLoginIp) {
		this.lastLoginIp = lastLoginIp;
		return this;
	}

	public Date getLastLoginTime() {
		return lastLoginTime;
	}

	public FbUserBase setLastLoginTime(Date lastLoginTime) {
		this.lastLoginTime = lastLoginTime;
		return this;
	}

	public Integer getLoginErrorCount() {
		return loginErrorCount;
	}

	public FbUserBase setLoginErrorCount(Integer loginErrorCount) {
		this.loginErrorCount = loginErrorCount;
		return this;
	}

	public Long getLoginLockTime() {
		return loginLockTime;
	}

	public FbUserBase setLoginLockTime(Long loginLockTime) {
		this.loginLockTime = loginLockTime;
		return this;
	}

	public Integer getPlatform() {
		return platform;
	}

	public FbUserBase setPlatform(Integer platform) {
		this.platform = platform;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbUserBase setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbUserBase setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbUserBase setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String O_UID = "o_uid";

	public static final String BASE_ID = "base_id";

	public static final String USER_TYPE = "user_type";

	public static final String IS_CHILD = "is_child";

	public static final String USERNAME = "username";

	public static final String USERPWD = "userpwd";

	public static final String SALT = "salt";

	public static final String STATUS = "status";

	public static final String MOBILE = "mobile";

	public static final String QQ = "qq";

	public static final String EMAIL = "email";

	public static final String PROVINCE_CODE = "province_code";

	public static final String PROVINCE_NAME = "province_name";

	public static final String CITY_CODE = "city_code";

	public static final String CITY_NAME = "city_name";

	public static final String AREA_CODE = "area_code";

	public static final String AREA_NAME = "area_name";

	public static final String ADDRESS = "address";

	public static final String LAST_LOGIN_IP = "last_login_ip";

	public static final String LAST_LOGIN_TIME = "last_login_time";

	public static final String LOGIN_ERROR_COUNT = "login_error_count";

	public static final String LOGIN_LOCK_TIME = "login_lock_time";

	public static final String PLATFORM = "platform";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbUserBase{" +
			", id=" + id +
			", oUid=" + oUid +
			", baseId=" + baseId +
			", userType=" + userType +
			", isChild=" + isChild +
			", username=" + username +
			", userpwd=" + userpwd +
			", salt=" + salt +
			", status=" + status +
			", mobile=" + mobile +
			", qq=" + qq +
			", email=" + email +
			", provinceCode=" + provinceCode +
			", provinceName=" + provinceName +
			", cityCode=" + cityCode +
			", cityName=" + cityName +
			", areaCode=" + areaCode +
			", areaName=" + areaName +
			", address=" + address +
			", lastLoginIp=" + lastLoginIp +
			", lastLoginTime=" + lastLoginTime +
			", loginErrorCount=" + loginErrorCount +
			", loginLockTime=" + loginLockTime +
			", platform=" + platform +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
