package com.fshows.lifecircle.user.service.dao;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.fshows.lifecircle.user.service.domain.po.FbOemNodeRight;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * <p>
 * OEM商功能菜单关系 Mapper 接口
 * </p>
 *
 * @author BuHao
 * @since 2017-12-14
 */
public interface FbOemNodeRightMapper extends BaseMapper<FbOemNodeRight> {

    List<Map<String,Object>> selectOemRights(@Param("oemId") long oemId);

    /**
     * 获得节点 id
     * @param oemId
     * @return
     */
    @Select("SELECT node_id FROM fb_oem_node_right WHERE oem_id = #{oemId} AND is_del = 0")
    List<Long> findNodeId(@Param("oemId") Long oemId);
}
