/**
 * fshows.com
 * Copyright (C) 2013-2018 All Rights Reserved.
 */
package com.fshows.lifecircle.service.store.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.store.openapi.facade.domain.*;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

import java.util.List;

/**
 * 项目：lifecircle-service-store
 * 包名：com.fshows.lifecircle.service.store.openapi.facade.api.rpc
 * 功能：
 * 创建时间：2018-01-16 15:43
 * 更新记录：
 * @author BuHao
 */
public interface StoreApi {

  /**
   * 添加店铺
   * @param param
   * @return
   */
  BizResponse<Long> addOrUpdateStore(StoreParam param);

  /**
   * 根据 storeId 获得店铺详情
   * @param storeId
   * @return
   */
  BizResponse<StoreInfoResult> getByStoreId(Long storeId);

  /**
   * 店铺列表接口
   * @return
   */
  BizResponse<PageResult<StoreInfoResult>> findByStoreList(StoreQueryParam param);


  /**
   * 添加修改店铺审核记录
   * @param param
   * @return
   */
  BizResponse addOrUpdateStoreExamineRecord(StoreExamineRecordParam param);

  /**
   * 获得审核记录
   * @param storeId
   * @return
   */
  BizResponse<StoreExamineRecordResult> getStoreExamineRecord(Long storeId);

  /**
   * 根据mid获取所持有门店列表
   * @param mid
   * @return
   */
  BizResponse<List<StoreInfoResult>> findByMid(Long mid);

  /**
   * 新增门店脚本
   * @param param
   * @return
   */
  BizResponse<TaskResult> storeTask(StoreTaskParam param);
}
