package com.fshows.lifecircle.service.store.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 门店基础信息
 * </p>
 *
 * @author BuHao
 * @since 2018-01-21
 */
@TableName("fb_store_info")
public class FbStoreInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Integer id;
    /**
     * 门店ID
     */
	@TableField("store_id")
	private Long storeId;
    /**
     * 门店名称
     */
	@TableField("store_name")
	private String storeName;
    /**
     * 所属商户ID
     */
	private Long mid;
    /**
     * 商家名称
     */
	@TableField("m_title")
	private String mTitle;
    /**
     * 所属代理商ID
     */
	@TableField("agent_id")
	private Long agentId;
    /**
     * 代理商公司名称
     */
	@TableField("agent_company")
	private String agentCompany;
    /**
     * 所属OEM商ID
     */
	@TableField("oem_id")
	private Long oemId;
    /**
     * OEM商名称(OEM表admin_title)
     */
	@TableField("oem_title")
	private String oemTitle;
    /**
     * 审核状态 0未审核 1代理商审核通过（系统待处理） 2代理商审核拒绝 3系统审核通过 4系统审核拒绝
     */
	private Integer status;
    /**
     * 上架状态 0（待营业） 1 （营业中）2已关闭
     */
	@TableField("is_online")
	private Integer isOnline;
    /**
     * 口碑分类ID
     */
	@TableField("category_id")
	private String categoryId;
    /**
     * 类目名称
     */
	@TableField("category_name")
	private String categoryName;
    /**
     * 省份code（gaode）
     */
	@TableField("province_code")
	private String provinceCode;
    /**
     * 省份名称（gaode）
     */
	@TableField("province_name")
	private String provinceName;
    /**
     * 城市code（gaode）
     */
	@TableField("city_code")
	private String cityCode;
    /**
     * 城市名称（gaode）
     */
	@TableField("city_name")
	private String cityName;
    /**
     * 区域code（gaode）
     */
	@TableField("area_code")
	private String areaCode;
    /**
     * 区域名称（gaode）
     */
	@TableField("area_name")
	private String areaName;
    /**
     * 详细地址
     */
	private String address;
    /**
     * 经度
     */
	private Float longitude;
    /**
     * 维度
     */
	private Float latitude;
    /**
     * 门店电话
     */
	private String tel;
    /**
     * 每日营业开门时间
     */
	@TableField("open_time")
	private String openTime;
    /**
     * 每日营业关门时间
     */
	@TableField("end_time")
	private String endTime;
    /**
     * 人均消费价格
     */
	@TableField("avg_price")
	private Integer avgPrice;
    /**
     * 提供服务，以逗号分割的字符串，1停车位，2包厢，3WIFI，4无烟区
     */
	private String service;
    /**
     * 门店简介
     */
	@TableField("store_brief")
	private String storeBrief;
    /**
     * 品牌LOGO
     */
	@TableField("store_logo")
	private String storeLogo;
    /**
     * 门店图片，以JSON格式存储
     */
	@TableField("store_image")
	private String storeImage;
    /**
     * 经营许可证照片
     */
	@TableField("license_photo")
	private String licensePhoto;
    /**
     * 营业执照照片
     */
	@TableField("id_photo")
	private String idPhoto;
    /**
     * 营业执照编号/名称
     */
	@TableField("lincense_id")
	private String lincenseId;
    /**
     * 添加门店渠道 1：APP
     */
	@TableField("join_channel")
	private Integer joinChannel;
    /**
     * 是否删除 0 未删除 1 已删除
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Integer getId() {
		return id;
	}

	public FbStoreInfo setId(Integer id) {
		this.id = id;
		return this;
	}

	public Long getStoreId() {
		return storeId;
	}

	public FbStoreInfo setStoreId(Long storeId) {
		this.storeId = storeId;
		return this;
	}

	public String getStoreName() {
		return storeName;
	}

	public FbStoreInfo setStoreName(String storeName) {
		this.storeName = storeName;
		return this;
	}

	public Long getMid() {
		return mid;
	}

	public FbStoreInfo setMid(Long mid) {
		this.mid = mid;
		return this;
	}

	public String getmTitle() {
		return mTitle;
	}

	public FbStoreInfo setmTitle(String mTitle) {
		this.mTitle = mTitle;
		return this;
	}

	public Long getAgentId() {
		return agentId;
	}

	public FbStoreInfo setAgentId(Long agentId) {
		this.agentId = agentId;
		return this;
	}

	public String getAgentCompany() {
		return agentCompany;
	}

	public FbStoreInfo setAgentCompany(String agentCompany) {
		this.agentCompany = agentCompany;
		return this;
	}

	public Long getOemId() {
		return oemId;
	}

	public FbStoreInfo setOemId(Long oemId) {
		this.oemId = oemId;
		return this;
	}

	public String getOemTitle() {
		return oemTitle;
	}

	public FbStoreInfo setOemTitle(String oemTitle) {
		this.oemTitle = oemTitle;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public FbStoreInfo setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Integer getIsOnline() {
		return isOnline;
	}

	public FbStoreInfo setIsOnline(Integer isOnline) {
		this.isOnline = isOnline;
		return this;
	}

	public String getCategoryId() {
		return categoryId;
	}

	public FbStoreInfo setCategoryId(String categoryId) {
		this.categoryId = categoryId;
		return this;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public FbStoreInfo setCategoryName(String categoryName) {
		this.categoryName = categoryName;
		return this;
	}

	public String getProvinceCode() {
		return provinceCode;
	}

	public FbStoreInfo setProvinceCode(String provinceCode) {
		this.provinceCode = provinceCode;
		return this;
	}

	public String getProvinceName() {
		return provinceName;
	}

	public FbStoreInfo setProvinceName(String provinceName) {
		this.provinceName = provinceName;
		return this;
	}

	public String getCityCode() {
		return cityCode;
	}

	public FbStoreInfo setCityCode(String cityCode) {
		this.cityCode = cityCode;
		return this;
	}

	public String getCityName() {
		return cityName;
	}

	public FbStoreInfo setCityName(String cityName) {
		this.cityName = cityName;
		return this;
	}

	public String getAreaCode() {
		return areaCode;
	}

	public FbStoreInfo setAreaCode(String areaCode) {
		this.areaCode = areaCode;
		return this;
	}

	public String getAreaName() {
		return areaName;
	}

	public FbStoreInfo setAreaName(String areaName) {
		this.areaName = areaName;
		return this;
	}

	public String getAddress() {
		return address;
	}

	public FbStoreInfo setAddress(String address) {
		this.address = address;
		return this;
	}

	public Float getLongitude() {
		return longitude;
	}

	public FbStoreInfo setLongitude(Float longitude) {
		this.longitude = longitude;
		return this;
	}

	public Float getLatitude() {
		return latitude;
	}

	public FbStoreInfo setLatitude(Float latitude) {
		this.latitude = latitude;
		return this;
	}

	public String getTel() {
		return tel;
	}

	public FbStoreInfo setTel(String tel) {
		this.tel = tel;
		return this;
	}

	public String getOpenTime() {
		return openTime;
	}

	public FbStoreInfo setOpenTime(String openTime) {
		this.openTime = openTime;
		return this;
	}

	public String getEndTime() {
		return endTime;
	}

	public FbStoreInfo setEndTime(String endTime) {
		this.endTime = endTime;
		return this;
	}

	public Integer getAvgPrice() {
		return avgPrice;
	}

	public FbStoreInfo setAvgPrice(Integer avgPrice) {
		this.avgPrice = avgPrice;
		return this;
	}

	public String getService() {
		return service;
	}

	public FbStoreInfo setService(String service) {
		this.service = service;
		return this;
	}

	public String getStoreBrief() {
		return storeBrief;
	}

	public FbStoreInfo setStoreBrief(String storeBrief) {
		this.storeBrief = storeBrief;
		return this;
	}

	public String getStoreLogo() {
		return storeLogo;
	}

	public FbStoreInfo setStoreLogo(String storeLogo) {
		this.storeLogo = storeLogo;
		return this;
	}

	public String getStoreImage() {
		return storeImage;
	}

	public FbStoreInfo setStoreImage(String storeImage) {
		this.storeImage = storeImage;
		return this;
	}

	public String getLicensePhoto() {
		return licensePhoto;
	}

	public FbStoreInfo setLicensePhoto(String licensePhoto) {
		this.licensePhoto = licensePhoto;
		return this;
	}

	public String getIdPhoto() {
		return idPhoto;
	}

	public FbStoreInfo setIdPhoto(String idPhoto) {
		this.idPhoto = idPhoto;
		return this;
	}

	public String getLincenseId() {
		return lincenseId;
	}

	public FbStoreInfo setLincenseId(String lincenseId) {
		this.lincenseId = lincenseId;
		return this;
	}

	public Integer getJoinChannel() {
		return joinChannel;
	}

	public FbStoreInfo setJoinChannel(Integer joinChannel) {
		this.joinChannel = joinChannel;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbStoreInfo setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbStoreInfo setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbStoreInfo setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String STORE_ID = "store_id";

	public static final String STORE_NAME = "store_name";

	public static final String MID = "mid";

	public static final String M_TITLE = "m_title";

	public static final String AGENT_ID = "agent_id";

	public static final String AGENT_COMPANY = "agent_company";

	public static final String OEM_ID = "oem_id";

	public static final String OEM_TITLE = "oem_title";

	public static final String STATUS = "status";

	public static final String IS_ONLINE = "is_online";

	public static final String CATEGORY_ID = "category_id";

	public static final String CATEGORY_NAME = "category_name";

	public static final String PROVINCE_CODE = "province_code";

	public static final String PROVINCE_NAME = "province_name";

	public static final String CITY_CODE = "city_code";

	public static final String CITY_NAME = "city_name";

	public static final String AREA_CODE = "area_code";

	public static final String AREA_NAME = "area_name";

	public static final String ADDRESS = "address";

	public static final String LONGITUDE = "longitude";

	public static final String LATITUDE = "latitude";

	public static final String TEL = "tel";

	public static final String OPEN_TIME = "open_time";

	public static final String END_TIME = "end_time";

	public static final String AVG_PRICE = "avg_price";

	public static final String SERVICE = "service";

	public static final String STORE_BRIEF = "store_brief";

	public static final String STORE_LOGO = "store_logo";

	public static final String STORE_IMAGE = "store_image";

	public static final String LICENSE_PHOTO = "license_photo";

	public static final String ID_PHOTO = "id_photo";

	public static final String LINCENSE_ID = "lincense_id";

	public static final String JOIN_CHANNEL = "join_channel";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbStoreInfo{" +
			", id=" + id +
			", storeId=" + storeId +
			", storeName=" + storeName +
			", mid=" + mid +
			", mTitle=" + mTitle +
			", agentId=" + agentId +
			", agentCompany=" + agentCompany +
			", oemId=" + oemId +
			", oemTitle=" + oemTitle +
			", status=" + status +
			", isOnline=" + isOnline +
			", categoryId=" + categoryId +
			", categoryName=" + categoryName +
			", provinceCode=" + provinceCode +
			", provinceName=" + provinceName +
			", cityCode=" + cityCode +
			", cityName=" + cityName +
			", areaCode=" + areaCode +
			", areaName=" + areaName +
			", address=" + address +
			", longitude=" + longitude +
			", latitude=" + latitude +
			", tel=" + tel +
			", openTime=" + openTime +
			", endTime=" + endTime +
			", avgPrice=" + avgPrice +
			", service=" + service +
			", storeBrief=" + storeBrief +
			", storeLogo=" + storeLogo +
			", storeImage=" + storeImage +
			", licensePhoto=" + licensePhoto +
			", idPhoto=" + idPhoto +
			", lincenseId=" + lincenseId +
			", joinChannel=" + joinChannel +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
