package com.fshows.lifecircle.service.store.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 门店审核信息
 * </p>
 *
 * @author BuHao
 * @since 2018-01-15
 */
@TableName("fb_store_examine_record")
public class FbStoreExamineRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
	@TableId(value="id", type= IdType.AUTO)
	private Integer id;
    /**
     * 审核编号
     */
	@TableField("examine_id")
	private Long examineId;
    /**
     * 门店ID
     */
	@TableField("store_id")
	private Long storeId;
    /**
     * 门店名称
     */
	@TableField("store_name")
	private String storeName;
    /**
     * 审核信息
     */
	@TableField("examine_json")
	private String examineJson;
    /**
     * 总店信息，添加异地门店审核时候使用 json 包含总部地址和名称
     */
	@TableField("main_store_info")
	private String mainStoreInfo;
    /**
     * 审核状态 0未审核 1代理商审核通过（系统待处理） 2代理商审核拒绝 3系统审核通过 4系统审核拒绝
     */
	@TableField("examine_status")
	private Integer examineStatus;
    /**
     * 审核时间
     */
	@TableField("examine_time")
	private Long examineTime;
    /**
     * 代理商审核人用户ID
     */
	@TableField("examine_uid")
	private Long examineUid;
    /**
     * 代理商审核人用户名称
     */
	@TableField("examine_username")
	private String examineUsername;
    /**
     * 代理商拒绝理由
     */
	@TableField("reject_reason")
	private String rejectReason;
    /**
     * 系统审核时间
     */
	@TableField("second_examine_time")
	private Long secondExamineTime;
    /**
     * 系统审核人用户ID
     */
	@TableField("second_examine_uid")
	private Long secondExamineUid;
    /**
     * 系统审核人用户名称
     */
	@TableField("second_examine_username")
	private String secondExamineUsername;
    /**
     * 系统拒绝理由
     */
	@TableField("second_reject_reason")
	private String secondRejectReason;
    /**
     * 是否删除 0 未删除 1 已删除
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Integer getId() {
		return id;
	}

	public FbStoreExamineRecord setId(Integer id) {
		this.id = id;
		return this;
	}

	public Long getExamineId() {
		return examineId;
	}

	public FbStoreExamineRecord setExamineId(Long examineId) {
		this.examineId = examineId;
		return this;
	}

	public Long getStoreId() {
		return storeId;
	}

	public FbStoreExamineRecord setStoreId(Long storeId) {
		this.storeId = storeId;
		return this;
	}

	public String getStoreName() {
		return storeName;
	}

	public FbStoreExamineRecord setStoreName(String storeName) {
		this.storeName = storeName;
		return this;
	}

	public String getExamineJson() {
		return examineJson;
	}

	public FbStoreExamineRecord setExamineJson(String examineJson) {
		this.examineJson = examineJson;
		return this;
	}

	public String getMainStoreInfo() {
		return mainStoreInfo;
	}

	public FbStoreExamineRecord setMainStoreInfo(String mainStoreInfo) {
		this.mainStoreInfo = mainStoreInfo;
		return this;
	}

	public Integer getExamineStatus() {
		return examineStatus;
	}

	public FbStoreExamineRecord setExamineStatus(Integer examineStatus) {
		this.examineStatus = examineStatus;
		return this;
	}

	public Long getExamineTime() {
		return examineTime;
	}

	public FbStoreExamineRecord setExamineTime(Long examineTime) {
		this.examineTime = examineTime;
		return this;
	}

	public Long getExamineUid() {
		return examineUid;
	}

	public FbStoreExamineRecord setExamineUid(Long examineUid) {
		this.examineUid = examineUid;
		return this;
	}

	public String getExamineUsername() {
		return examineUsername;
	}

	public FbStoreExamineRecord setExamineUsername(String examineUsername) {
		this.examineUsername = examineUsername;
		return this;
	}

	public String getRejectReason() {
		return rejectReason;
	}

	public FbStoreExamineRecord setRejectReason(String rejectReason) {
		this.rejectReason = rejectReason;
		return this;
	}

	public Long getSecondExamineTime() {
		return secondExamineTime;
	}

	public FbStoreExamineRecord setSecondExamineTime(Long secondExamineTime) {
		this.secondExamineTime = secondExamineTime;
		return this;
	}

	public Long getSecondExamineUid() {
		return secondExamineUid;
	}

	public FbStoreExamineRecord setSecondExamineUid(Long secondExamineUid) {
		this.secondExamineUid = secondExamineUid;
		return this;
	}

	public String getSecondExamineUsername() {
		return secondExamineUsername;
	}

	public FbStoreExamineRecord setSecondExamineUsername(String secondExamineUsername) {
		this.secondExamineUsername = secondExamineUsername;
		return this;
	}

	public String getSecondRejectReason() {
		return secondRejectReason;
	}

	public FbStoreExamineRecord setSecondRejectReason(String secondRejectReason) {
		this.secondRejectReason = secondRejectReason;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbStoreExamineRecord setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbStoreExamineRecord setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbStoreExamineRecord setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String EXAMINE_ID = "examine_id";

	public static final String STORE_ID = "store_id";

	public static final String STORE_NAME = "store_name";

	public static final String EXAMINE_JSON = "examine_json";

	public static final String MAIN_STORE_INFO = "main_store_info";

	public static final String EXAMINE_STATUS = "examine_status";

	public static final String EXAMINE_TIME = "examine_time";

	public static final String EXAMINE_UID = "examine_uid";

	public static final String EXAMINE_USERNAME = "examine_username";

	public static final String REJECT_REASON = "reject_reason";

	public static final String SECOND_EXAMINE_TIME = "second_examine_time";

	public static final String SECOND_EXAMINE_UID = "second_examine_uid";

	public static final String SECOND_EXAMINE_USERNAME = "second_examine_username";

	public static final String SECOND_REJECT_REASON = "second_reject_reason";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbStoreExamineRecord{" +
			", id=" + id +
			", examineId=" + examineId +
			", storeId=" + storeId +
			", storeName=" + storeName +
			", examineJson=" + examineJson +
			", mainStoreInfo=" + mainStoreInfo +
			", examineStatus=" + examineStatus +
			", examineTime=" + examineTime +
			", examineUid=" + examineUid +
			", examineUsername=" + examineUsername +
			", rejectReason=" + rejectReason +
			", secondExamineTime=" + secondExamineTime +
			", secondExamineUid=" + secondExamineUid +
			", secondExamineUsername=" + secondExamineUsername +
			", secondRejectReason=" + secondRejectReason +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
