/**
 * Copyright (c) 2018; buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.pay.openapi.facade.domain.pay;

import com.fshows.lifecircle.service.pay.openapi.facade.domain.enums.PayChannelEnum;
import com.fshows.lifecircle.service.pay.openapi.facade.domain.enums.PayTypeEnum;
import java.math.BigDecimal;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.openapi.facade.domain.pay
 * 功能：
 * 创建时间：2018-03-03 16:33
 * 更新记录：
 *
 * @author BuHao
 */
@Data
@Accessors(chain = true)
public class PlatformH5PayParam {

  /**
   * 订单金额
   */
  private BigDecimal orderPrice;
  /**
   * 备注
   */
  private String memo;
  /**
   * oem id
   */
  private Long oemId;
  /**
   * 代理商 id
   */
  private Long agentId;
  /**
   * 商户 id
   */
  private Long mid;
  /**
   * 受理商 id
   */
  private Long grantId;
  /**
   * 店铺 id
   */
  private Long storeId;
  /**
   * 收银员 id
   */
  private Long cashierId;
  /**
   * 平台用户id
   */
  private String openid;
  /**
   * 客户端 ip 地址
   */
  private String ip;
  /**
   * 支付渠道
   */
  private PayChannelEnum payChannelEnum;
  /**
   * 支付方式
   */
  private PayTypeEnum payTypeEnum;
}
