package com.fshows.lifecircle.service.pay.openapi.facade.domain.order;

import lombok.Data;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.openapi.facade.domain.order
 * 功能： 账单查询结果返回值
 * 创建时间 ： 2018-03-07 14:13
 *
 * @author: Wangxj
 **/
@Data
@Slf4j
@Accessors(chain = true)
public class OrderQueryResult {
    private static final long serialVersionUID = 1L;

    private Long id;
    /**
     * 订单号
     */
    private String orderSn;
    /**
     * C端用户ID
     */
    private Long cid;
    /**
     * C端用户昵称
     */
    private String nick;
    /**
     * C端用户头像；
     */
    private String headImg;
    /**
     * 支付方式
     */
    private Integer payChannel;
    /**
     * 支付金额
     */
    private String payAmount;
    /**
     * 订单真实付款金额
     */
    private String realPayAmount;
    /**
     * 交易总费率
     */
    private String payRate;
    /**
     * 交易手续费
     */
    private String poundage;
    /**
     * 支付状态 101待支付，201支付成功，301已关闭
     */
    private Integer payStatus;

    /**
     * 创建时间
     */
    private long createTime;
    /**
     * 修改时间
     */
    private long updateTime;
}
