package com.fshows.lifecircle.service.pay.openapi.facade.domain.rate;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class FbAgentRateResult implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * 支付渠道
     */
    private Integer channelId;
    /**
     * 代理商ID
     */
    private Long agentId;
    /**
     * OEM利润率
     */
    private BigDecimal rate;
    /**
     * 代理商最大利润率
     */
    private BigDecimal maxRate;
    /**
     * 代理商最小利润率
     */
    private BigDecimal minRate;
    /**
     * 备注
     */
    private String memo;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;
}