/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.pay.openapi.facade.domain.pay;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.openapi.facade.domain.pay
 * 功能：
 * 创建时间：2018-03-03 16:34
 * 更新记录：
 * @author BuHao
 */
@Data
@Accessors(chain = true)
public class PlatformH5PayResult {

  /**
   * 预下单id
   */
  private String prepayId;

  /**
   * 公众号id
   */
  private String appId;

  /**
   * 时间戳
   */
  private Long timeStamp;

  /**
   * 随机字符串
   */
  private String nonceStr;

  /**
   * 订单详情扩展字符串，统一下单接口返回的prepay_id参数值，提交格式如：prepay_id=***
   */
  private String packages;

  /**
   * 签名方式，签名算法，暂支持MD5
   */
  private String signType;

  /**
   * 签名
   */
  private String paySign;
}
