/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.pay.openapi.facade.domain.order;

import com.fshows.lifecircle.service.pay.openapi.facade.domain.enums.PayChannelEnum;
import com.fshows.lifecircle.service.pay.openapi.facade.domain.enums.PaySourceEnum;
import com.fshows.lifecircle.service.pay.openapi.facade.domain.enums.PayTypeEnum;
import java.math.BigDecimal;
import lombok.Data;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.openapi.facade.domain.order
 * 功能：
 * 创建时间：2018-03-03 15:15
 * 更新记录：
 * @author BuHao
 */
@Data
@Slf4j
@Accessors(chain = true)
public class OrderCreateParam {

  /**
   * 订单金额
   */
  private BigDecimal orderPrice;
  /**
   * 实际支付金额
   */
  private BigDecimal realMoney;
  /**
   * 备注
   */
  private String memo;
  /**
   * oem id
   */
  private Long oemId;
  /**
   * 代理商 id
   */
  private Long agentId;
  /**
   * 第三方用户id
   */
  private String openid;
  /**
   * c 端用户id
   */
  private Long cid;
  /**
   * 商户 id
   */
  private Long mid;
  /**
   * 受理商 id
   */
  private Long grantId;
  /**
   * 店铺 id
   */
  private Long storeId;
  /**
   * 店铺名称
   */
  private String storeName;
  /**
   * 收银员 id
   */
  private Long cashierId;
  /**
   * 支付总费率
   */
  private BigDecimal payRate;
  /**
   * 支付总费用
   */
  private BigDecimal poundage;
  /**
   * 支付来源
   */
  private PaySourceEnum paySourceEnum;
  /**
   * 支付渠道
   */
  private PayChannelEnum payChannelEnum;
  /**
   * 支付类型
   */
  private PayTypeEnum payTypeEnum;
}
