package com.fshows.lifecircle.service.pay.openapi.facade.domain.enums;

/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.openapi.facade.domain.enums
 * 功能：
 * 创建时间：2018-03-05 20:14
 * 更新记录：
 *
 * @author BuHao
 */
public enum PayStatusEnum {

  /**
   * 待续支付
   */
  PAY_WAIT(101, "PAY_WAIT"),
  /**
   * 支付成功
   */
  PAY_SUCCESS(201, "PAY_SUCCESS"),
  /**
   * 支付关闭
   */
  PAY_CLOSE(301, "PAY_CLOSE"),
  /**
   * 退款
   */
  PAY_REFUND(401, "PAY_REFUND"),
  /**
   * 支付撤销
   */
  PAY_UNDO(501, "PAY_UNDO");

  private Integer code;
  private String name;

  PayStatusEnum(Integer code, String name) {
    this.code = code;
    this.name = name;
  }

  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }
}
