/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.openapi.facade.api.rpc
 * 功能：
 * 创建时间：2018-03-03 20:05
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.service.pay.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.pay.openapi.facade.domain.pay.*;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import java.util.Map;

import java.math.BigDecimal;

/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.openapi.facade.api.rpc
 * 功能：
 * 创建时间：2018-03-03 20:05
 * 更新记录：
 * @author BuHao
 */
public interface IPayApi {

  /**
   * h5 支付接口
   * @param platformH5PayParam
   * @return
   */
  BizResponse<PlatformH5PayResult> h5Pay(PlatformH5PayParam platformH5PayParam);

  //扫码支付
  BizResponse qrcodePay(PlatformQrcodePayParam param);

  //刷卡
  BizResponse swipePay(PlatformSwipePayParam param);

  BizResponse orderQuery(PlatformOrderQueryParam param);

  /**
   * 支付回调接口
   * @param params
   * @return
   */
  BizResponse<String> callback(Map<String, Object> params);
}
