package com.fshows.lifecircle.service.operation.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 系统配置信息
 * </p>
 *
 * @author BuHao
 * @since 2018-01-06
 */
@TableName("fb_system_config")
public class FbSystemConfig implements Serializable {

    private static final long serialVersionUID = 1L;

	@TableId(value="id", type= IdType.AUTO)
	private Integer id;
    /**
     * 配置名称
     */
	private String title;
    /**
     * 字段key
     */
    @TableField("config_key")
	private String configKey;
    /**
     * 字段value
     */
    @TableField("config_value")
	private String configValue;
    /**
     * 是否删除 0 未删除 1 已删除
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Integer getId() {
		return id;
	}

	public FbSystemConfig setId(Integer id) {
		this.id = id;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public FbSystemConfig setTitle(String title) {
		this.title = title;
		return this;
	}

	public String getConfigKey() {
		return configKey;
	}

	public FbSystemConfig setConfigKey(String configKey) {
		this.configKey = configKey;
		return this;
	}

	public String getConfigValue() {
		return configValue;
	}

	public FbSystemConfig setConfigValue(String configValue) {
		this.configValue = configValue;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbSystemConfig setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbSystemConfig setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbSystemConfig setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String TITLE = "title";

	public static final String CONFIG_KEY = "config_key";

	public static final String CONFIG_VALUE = "config_value";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbSystemConfig{" +
			", id=" + id +
			", title=" + title +
			", configKey=" + configKey +
			", configValue=" + configValue +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
