package com.fshows.lifecircle.service.operation.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * APP版本管理
 * </p>
 *
 * @author BuHao
 * @since 2018-01-06
 */
@TableName("fb_app_version")
public class FbAppVersion implements Serializable {

    private static final long serialVersionUID = 1L;

	@TableId(value="id", type= IdType.AUTO)
	private Integer id;
    /**
     * app名称
     */
	@TableField("app_name")
	private String appName;
    /**
     * app版本号
     */
	@TableField("version_code")
	private String versionCode;
    /**
     * 下载网址
     */
	@TableField("download_url")
	private String downloadUrl;
    /**
     * 更新内容
     */
	@TableField("update_msg")
	private String updateMsg;
    /**
     * 是否强制更新 1是 0否
     */
	@TableField("is_must_update")
	private Integer isMustUpdate;
    /**
     * 状态 1启用 0未启用
     */
	private Integer status;
    /**
     * 是否删除 0 未删除 1 已删除
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Integer getId() {
		return id;
	}

	public FbAppVersion setId(Integer id) {
		this.id = id;
		return this;
	}

	public String getAppName() {
		return appName;
	}

	public FbAppVersion setAppName(String appName) {
		this.appName = appName;
		return this;
	}

	public String getVersionCode() {
		return versionCode;
	}

	public FbAppVersion setVersionCode(String versionCode) {
		this.versionCode = versionCode;
		return this;
	}

	public String getDownloadUrl() {
		return downloadUrl;
	}

	public FbAppVersion setDownloadUrl(String downloadUrl) {
		this.downloadUrl = downloadUrl;
		return this;
	}

	public String getUpdateMsg() {
		return updateMsg;
	}

	public FbAppVersion setUpdateMsg(String updateMsg) {
		this.updateMsg = updateMsg;
		return this;
	}

	public Integer getIsMustUpdate() {
		return isMustUpdate;
	}

	public FbAppVersion setIsMustUpdate(Integer isMustUpdate) {
		this.isMustUpdate = isMustUpdate;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public FbAppVersion setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbAppVersion setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbAppVersion setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbAppVersion setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String APP_NAME = "app_name";

	public static final String VERSION_CODE = "version_code";

	public static final String DOWNLOAD_URL = "download_url";

	public static final String UPDATE_MSG = "update_msg";

	public static final String IS_MUST_UPDATE = "is_must_update";

	public static final String STATUS = "status";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbAppVersion{" +
			", id=" + id +
			", appName=" + appName +
			", versionCode=" + versionCode +
			", downloadUrl=" + downloadUrl +
			", updateMsg=" + updateMsg +
			", isMustUpdate=" + isMustUpdate +
			", status=" + status +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
