package com.fshows.lifecircle.service.operation.domain.po;

import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableLogic;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * APP启动页管理
 * </p>
 *
 * @author BuHao
 * @since 2018-01-06
 */
@TableName("fb_app_launch_page")
public class FbAppLaunchPage implements Serializable {

    private static final long serialVersionUID = 1L;

	@TableId(value="id", type= IdType.AUTO)
	private Integer id;
    /**
     * OEM商ID 如果为0表示公共的
     */
	@TableField("oem_id")
	private Long oemId;
    /**
     * 标题
     */
	private String title;
    /**
     * 启动页图片网址
     */
	@TableField("page_url")
	private String pageUrl;
    /**
     * 页面跳转地址
     */
	@TableField("link_url")
	private String linkUrl;
    /**
     * 状态 0未启用 1启用
     */
	private Integer status;
    /**
     * 是否删除 0 未删除 1 已删除
     */
	@TableField("is_del")
    @TableLogic
	private Integer isDel;
    /**
     * 创建时间
     */
	@TableField("create_time")
	private Date createTime;
    /**
     * 修改时间
     */
	@TableField("update_time")
	private Date updateTime;


	public Integer getId() {
		return id;
	}

	public FbAppLaunchPage setId(Integer id) {
		this.id = id;
		return this;
	}

	public Long getOemId() {
		return oemId;
	}

	public FbAppLaunchPage setOemId(Long oemId) {
		this.oemId = oemId;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public FbAppLaunchPage setTitle(String title) {
		this.title = title;
		return this;
	}

	public String getPageUrl() {
		return pageUrl;
	}

	public FbAppLaunchPage setPageUrl(String pageUrl) {
		this.pageUrl = pageUrl;
		return this;
	}

	public String getLinkUrl() {
		return linkUrl;
	}

	public FbAppLaunchPage setLinkUrl(String linkUrl) {
		this.linkUrl = linkUrl;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public FbAppLaunchPage setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Integer getIsDel() {
		return isDel;
	}

	public FbAppLaunchPage setIsDel(Integer isDel) {
		this.isDel = isDel;
		return this;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public FbAppLaunchPage setCreateTime(Date createTime) {
		this.createTime = createTime;
		return this;
	}

	public Date getUpdateTime() {
		return updateTime;
	}

	public FbAppLaunchPage setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	public static final String ID = "id";

	public static final String OEM_ID = "oem_id";

	public static final String TITLE = "title";

	public static final String PAGE_URL = "page_url";

	public static final String LINK_URL = "link_url";

	public static final String STATUS = "status";

	public static final String IS_DEL = "is_del";

	public static final String CREATE_TIME = "create_time";

	public static final String UPDATE_TIME = "update_time";

	@Override
	public String toString() {
		return "FbAppLaunchPage{" +
			", id=" + id +
			", oemId=" + oemId +
			", title=" + title +
			", pageUrl=" + pageUrl +
			", linkUrl=" + linkUrl +
			", status=" + status +
			", isDel=" + isDel +
			", createTime=" + createTime +
			", updateTime=" + updateTime +
			"}";
	}
}
