package com.fshows.lifecircle.service.commons.openapi.facade.domain.result;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.openapi.facade.domain.result
 * @description：描述
 * @updateDesription：更新记录描述
 * @date：2017/12/23
 * @author：Wendy
 */
public enum ErrorCode {
    /**
     * 推送错误
     */
    PUSH_CODE_ERROR("PUSH_CODE_ERROR", "推送失败"),
    /**
     * 验证码错误
     */
    VERIFICATION_CODE_ERROR("VERIFICATION_CODE_ERROR", "验证失败"),

    /**
     * 认证失败
     */
    AUTH_ERROR("AUTH_ERROR", "认证失败"),

    /**
     * OCR 错误
     */
    OCR_ERROR("OCR_ERROR", "OCR 识别错误"),

    /**
     * 验证码获取超出限制
     */
    VERIFICATION_CODE_LIMIT("VERIFICATION_CODE_LIMIT", ""),

    /**
     *
     */
    API_ERROR("API_ERROR", "外部接口调用错误");


    /**
     * 错误码
     */
    private String code;
    /**
     * 错误信息
     */
    private String msg;

    ErrorCode(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * 获得错误码
     * @return
     */
    public String getCode() {
        return this.code;
    }

    /**
     * 获得错误信息
     * @return
     */
    public String getMsg() {
        return this.msg;
    }
}
