package com.fshows.lifecircle.service.commons.openapi.facade.api;

import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.BankFourFactorResult;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.IdCardResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.openapi.facade.api
 * @description：描述：阿里安全认证模块
 * @updateDesription：更新记录描述
 * @date：2018/1/10
 * @author：Wendy
 */
public interface IApiSecurityAuth {
    /**
     * 实名认证
     * @param name
     * @param cardId
     * @return
     */
    BizResponse<Boolean> checkIdCard(String name, String cardId);

    /**
     * 身份证实名认证
     * @param bucketName
     * @param key
     * @return
     */
    BizResponse<IdCardResult> checkIdCardPicture(String bucketName, String key);

    /**
     * 银行卡四要素校验
     * @param name
     * @param acctPan
     * @param certId
     * @param phoneNum
     * @return
     */
    BizResponse<BankFourFactorResult> checkBankFourFactor(String name, String acctPan, String certId, String phoneNum);
}
