/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.riskcore.facade.enums;

import com.fshows.lifecircle.riskcore.facade.enums.WechatEventTypeEnum;
import org.apache.commons.lang3.StringUtils;

public enum WechatRiskTypeEnum {
    UNUSUAL_REAL_TIME_TRANSACTION("UNUSUAL_REAL_TIME_TRANSACTION", "\u6d89\u5acc\u5b9e\u65f6\u4ea4\u6613\u5f02\u5e38"),
    UNACCEPTABLE_DOCUMENTS("UNACCEPTABLE_DOCUMENTS", "\u6d89\u5acc\u8d44\u6599\u4e0d\u5408\u683c"),
    LARGE_AMOUNT_TRANSACTION("LARGE_AMOUNT_TRANSACTION", "\u6d89\u5acc\u5927\u989d\u4ea4\u6613"),
    ONE_YUAN_PURCHASES("ONE_YUAN_PURCHASES", "\u6d89\u5acc\u4e00\u5143\u8d2d"),
    MULTI_LEVEL_DISTRIBUTION_REBATE("MULTI_LEVEL_DISTRIBUTION_REBATE", "\u6d89\u5acc\u591a\u7ea7\u5206\u9500\u8fd4\u5229"),
    REFUND("REFUND", "\u9000\u6b3e\u7c7b\u578b\u7684\u95ee\u9898\u6295\u8bc9"),
    SERVICE_NOT_WORK("SERVICE_NOT_WORK", "\u670d\u52a1\u6743\u76ca\u672a\u751f\u6548"),
    UNCONFIRMED_WILLINGNESS_TO_OPEN_AN_ACCOUNT("UNCONFIRMED_WILLINGNESS_TO_OPEN_AN_ACCOUNT", "\u672a\u786e\u8ba4\u5f00\u6237\u610f\u613f"),
    ALL_MERCHANTS_HAVE_CONFIRMED_THE_WILLINGNESS_TO_OPEN_AN_ACCOUNT("ALL_MERCHANTS_HAVE_CONFIRMED_THE_WILLINGNESS_TO_OPEN_AN_ACCOUNT", "\u65e0\u4ea4\u6613\u5546\u6237\u672a\u786e\u8ba4\u5f00\u6237\u610f\u613f"),
    PROHIBITED_BUSINESS_CATEGORIES("PROHIBITED_BUSINESS_CATEGORIES", "\u6d89\u5acc\u6211\u53f8\u672a\u5f00\u653e\u7c7b\u76ee"),
    CASH_ADVANCE_VIA_CREDIT_CARD("CASH_ADVANCE_VIA_CREDIT_CARD", "\u6d89\u5acc\u4fe1\u7528\u5361\u5957\u73b0"),
    INDUCING_USERS_TO_MAKE_PAYMENTS("INDUCING_USERS_TO_MAKE_PAYMENTS", "\u6d89\u5acc\u8bf1\u5bfc\u652f\u4ed8"),
    FRAUD("INDUCING_USERS_TO_MAKE_PAYMENTS", "\u6d89\u5acc\u6b3a\u8bc8"),
    MALICIOUS_FAN_COUNT_BOOSTING("MALICIOUS_FAN_COUNT_BOOSTING", "\u6d89\u5acc\u6076\u610f\u5438\u7c89"),
    CROSS_CATEGORY_ACTIVITIES("CROSS_CATEGORY_ACTIVITIES", "\u6d89\u5acc\u8de8\u7c7b\u76ee"),
    CROSS_CATEGORY_BUSINESS("CROSS_CATEGORY_BUSINESS", "\u6d89\u5acc\u8de8\u7c7b\u76ee\u7ecf\u8425"),
    GAMBLING("GAMBLING", "\u6d89\u5acc\u8d4c\u535a"),
    LEWD_CONTENT("GAMBLING", "\u6d89\u5acc\u8272\u60c5"),
    UNLICENSED_PAYMENT_AND_SETTLEMENT_BUSINESS("UNLICENSED_PAYMENT_AND_SETTLEMENT_BUSINESS", "\u6d89\u5acc\u65e0\u8bc1\u7ecf\u8425\u652f\u4ed8\u7ed3\u7b97\u4e1a\u52a1"),
    INVESTMENT("INVESTMENT", "\u6d89\u5acc\u6295\u8d44\u7406\u8d22"),
    TRANSACTION_DISPUTE("TRANSACTION_DISPUTE", "\u6d89\u5acc\u4ea4\u6613\u7ea0\u7eb7"),
    CROSS_BORDER_USE_OF_DOMESTIC_PAYMENT_API("CROSS_BORDER_USE_OF_DOMESTIC_PAYMENT_API", "\u6d89\u5acc\u5883\u5185\u652f\u4ed8\u63a5\u53e3\u8de8\u5883\u4f7f\u7528"),
    OVERSEAS_ACTIVITIES_OUTSIDE_THE_BUSINESS_SCOPE_APPROVED_BY_REGULATORY_AUTHORITIES("OVERSEAS_ACTIVITIES_OUTSIDE_THE_BUSINESS_SCOPE_APPROVED_BY_REGULATORY_AUTHORITIES", "\u6d89\u5acc\u5883\u5916\u8d85\u76d1\u7ba1\u6279\u590d\u8303\u56f4\u7ecf\u8425"),
    UNUSUAL_TRANSACTION("UNUSUAL_TRANSACTION", "\u6d89\u5acc\u4ea4\u6613\u5f02\u5e38"),
    UNLICENSED_BUSINESS("UNLICENSED_BUSINESS", "\u6d89\u5acc\u65e0\u8d44\u8d28\u7ecf\u8425"),
    WEALTH_INVESTMENT("WEALTH_INVESTMENT", "\u6d89\u5acc\u6295\u8d44\u7406\u8d22"),
    AFFILIATED_TO_A_VIOLATING_ENTITY("AFFILIATED_TO_A_VIOLATING_ENTITY", "\u6d89\u5acc\u5173\u8054\u8fdd\u89c4\u4e3b\u4f53\u7b49\u5f02\u5e38\u98ce\u9669"),
    INVOLVED_IN_A_JUDICIAL_CASE("INVOLVED_IN_A_JUDICIAL_CASE", "\u6d89\u5acc\u53f8\u6cd5\u6848\u4ef6"),
    INCORRECT_INFORMATION_SUBMITTED("INCORRECT_INFORMATION_SUBMITTED", "\u6d89\u5acc\u8d44\u6599\u5f02\u5e38"),
    APPEAL_SUCCESSFUL("APPEAL_SUCCESSFUL", "\u7533\u8bc9\u6210\u529f"),
    REPORTED_BY_OTHERS("REPORTED_BY_OTHERS", "\u6d89\u5acc\u4ed6\u4eba\u6295\u8bc9\u4e3e\u62a5"),
    VIOLATING_SMART_CATERING_ACTIVITIES("VIOLATING_SMART_CATERING_ACTIVITIES", "\u6d89\u5acc\u667a\u6167\u9910\u996e\u6d3b\u52a8\u8fdd\u89c4"),
    MORE_THAN_ONE_MERCHANT_UNDER_A_SINGLE_MERCHANT_ID("MORE_THAN_ONE_MERCHANT_UNDER_A_SINGLE_MERCHANT_ID", "\u6d89\u5acc\u540c\u4e00\u5546\u6237\u53f7\u4e0b\u6302\u591a\u4e2a\u5546\u6237"),
    CROSS_REGION_USE_OF_INTERNATIONAL_PAYMENT_API("CROSS_REGION_USE_OF_INTERNATIONAL_PAYMENT_API", "\u6d89\u5acc\u5883\u5916\u652f\u4ed8\u63a5\u53e3\u8de8\u533a\u57df"),
    INACTIVE_TRANSACTION("INACTIVE_TRANSACTION", "\u4ea4\u6613\u505c\u6ede"),
    OTHER_UNUSUAL_ACTIVITIES("OTHER_UNUSUAL_ACTIVITIES", "\u6d89\u5acc\u5176\u5b83\u5f02\u5e38");

    private String value;
    private String name;

    private WechatRiskTypeEnum(String value, String name) {
        this.value = value;
        this.name = name;
    }

    public static WechatRiskTypeEnum getByValue(String value) {
        WechatRiskTypeEnum[] valueList;
        for (WechatRiskTypeEnum v : valueList = WechatRiskTypeEnum.values()) {
            if (!v.getValue().equals(value)) continue;
            return v;
        }
        return null;
    }

    public static String getNameByValue(String value) {
        WechatRiskTypeEnum[] valueList;
        for (WechatRiskTypeEnum v : valueList = WechatRiskTypeEnum.values()) {
            if (!v.getValue().equals(value)) continue;
            return v.getName();
        }
        return OTHER_UNUSUAL_ACTIVITIES.getName();
    }

    public boolean matches(String value) {
        return StringUtils.isBlank((CharSequence)value) ? false : this.value.equals(value);
    }

    public static boolean matchesConditionEventTypedWithRiskType(String eventType, String riskType) {
        if (WechatEventTypeEnum.VIOLATION_INTERCEPT.matches(eventType)) {
            return UNUSUAL_REAL_TIME_TRANSACTION.matches(riskType);
        }
        if (WechatEventTypeEnum.VIOLATION_PUNISH.matches(eventType)) {
            return !UNCONFIRMED_WILLINGNESS_TO_OPEN_AN_ACCOUNT.matches(riskType) && !ALL_MERCHANTS_HAVE_CONFIRMED_THE_WILLINGNESS_TO_OPEN_AN_ACCOUNT.matches(riskType);
        }
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }
}

