/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.riskcore.facade.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum MerchantTypeEnum {
    PERSONAL_MERCHANT("\u4e2a\u4eba\u5546\u6237", 1),
    COMPANY_MERCHANT("\u4f01\u4e1a\u5546\u6237", 2),
    FOREIGNER_MERCHANT("\u6e2f\u6fb3\u53f0\u53ca\u5916\u7c4d\u5546\u6237", 3);

    public static final Map<Integer, String> map;
    private final String name;
    private final Integer value;

    private MerchantTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public static MerchantTypeEnum getByValue(Integer value) {
        MerchantTypeEnum[] valueList;
        for (MerchantTypeEnum v : valueList = MerchantTypeEnum.values()) {
            if (!v.getValue().equals(value)) continue;
            return v;
        }
        return null;
    }

    public static String valueOf(Integer value) {
        MerchantTypeEnum[] valueList;
        for (MerchantTypeEnum v : valueList = MerchantTypeEnum.values()) {
            if (!v.value.equals(value)) continue;
            return v.name;
        }
        return "";
    }

    public String getName() {
        return this.name;
    }

    public Integer getValue() {
        return this.value;
    }

    static {
        map = Maps.newLinkedHashMapWithExpectedSize((int)10);
        for (MerchantTypeEnum typeEnum : MerchantTypeEnum.values()) {
            map.put(typeEnum.value, typeEnum.name);
        }
    }
}

