/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.liquidationcore.facade.enums.common;

import org.apache.commons.lang3.StringUtils;

public enum TradeStateEnum {
    TRADE_SUCCESS("\u4ea4\u6613\u6210\u529f", "SUCCESS"),
    TRADE_FAIL("\u4ea4\u6613\u5931\u8d25", "FAIL"),
    TRADE_PAYING("\u652f\u4ed8\u4e2d", "PAYING"),
    TRADE_NOTPAY("\u672a\u652f\u4ed8", "NOTPAY"),
    TRADE_CLOSED("\u5df2\u5173\u95ed", "CLOSED"),
    TRADE_CANCELED("\u5df2\u64a4\u9500", "CANCELED"),
    REFUND_SUCCESS("\u9000\u6b3e\u6210\u529f", "REFUND_SUCCESS"),
    REFUND_FAIL("\u9000\u6b3e\u5931\u8d25", "REFUND_FAIL"),
    REFUND_PROCESSING("\u9000\u6b3e\u4e2d", "REFUND_PROCESSING"),
    REFUND_SUSPEND("\u9000\u6b3e\u4e2d\u65ad", "REFUND_SUSPEND");

    private String name;
    private String tradeState;

    private TradeStateEnum(String name, String tradeState) {
        this.name = name;
        this.tradeState = tradeState;
    }

    public static TradeStateEnum getByValue(String value) {
        TradeStateEnum[] valueList;
        for (TradeStateEnum v : valueList = TradeStateEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getTradeState(), (CharSequence)value)) continue;
            return v;
        }
        return TRADE_PAYING;
    }

    public String getName() {
        return this.name;
    }

    public String getTradeState() {
        return this.tradeState;
    }
}

