/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.liquidationcore.facade.enums.common;

import org.apache.commons.lang3.StringUtils;

public enum PayPlatformEnum {
    WECHAT("\u5bf0\ue1bb\u4fca", "WECHAT", 1, "WXZF", "2", "WECHAT", "WECHAT", "WECHAT", "WECHAT", "2", "wxpay"),
    ALIPAY("\u93c0\ue219\u7caf\u7039\ufffd", "ALIPAY", 2, "ZFBZF", "1", "ALIPAY", "ALIPAY", "ALIPAY", "ALIPAY", "3", "alipay"),
    UNIONPAY("\u95be\u60f0\u4ec8\u6d5c\u6226\u68ef\u6d60\ufffd", "UNIONPAY", 5, "UPSMZF", "6", "UQRCODEPAY", "UNIONPAY", "CUP", "UNIONPAY", "4", "unionpay"),
    POS("POS", "BANK_CARD", 9, "", "8", null, null, null, null, null, null),
    DCEP("\u93c1\u677f\u74e7\u6d5c\u70d8\u76af\u752f\ufffd", "DCEP", 40, "", "16", null, null, null, null, null, null),
    DYPAY("\u93b6\u682d\u7176", "DYPAY", 41, "", "", null, null, null, null, null, null),
    PRE_PAY_CARD("\u68f0\u52ea\u7caf\u9357\u2103\u656e\u6d60\ufffd", "PRE_PAY_CARD", null, "", "17", null, null, null, null, null, null),
    WANDA_COUPON_WRITE_OFF("\u6d93\u56ea\u63ea\u9357\u2033\u57dc\u93cd\u6401\u6522", "WANDA_COUPON_WRITE_OFF", 32, "", "", null, null, null, null, null, null),
    UNKNOW("\u93c8\ue046\u7161", "UNKNOW", null, "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW", "UNKNOW");

    private final String name;
    private final String value;
    private final Integer payType;
    private final String lsValue;
    private final String umpayValue;
    private final String lklValue;
    private final String yeepayValue;
    private final String xftValue;
    private final String fuiouValue;
    private final String ccbValue;
    private final String jlpayValue;

    private PayPlatformEnum(String name, String value, Integer payType, String lsValue, String umpayValue, String lklValue, String yeepayValue, String xftValue, String fuiouValue, String ccbValue, String jlpayValue) {
        this.name = name;
        this.value = value;
        this.payType = payType;
        this.lsValue = lsValue;
        this.umpayValue = umpayValue;
        this.lklValue = lklValue;
        this.yeepayValue = yeepayValue;
        this.xftValue = xftValue;
        this.fuiouValue = fuiouValue;
        this.ccbValue = ccbValue;
        this.jlpayValue = jlpayValue;
    }

    public static PayPlatformEnum getByValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByPayType(Integer payType) {
        PayPlatformEnum[] values;
        if (null == payType) {
            return UNKNOW;
        }
        for (PayPlatformEnum value : values = PayPlatformEnum.values()) {
            if (!value.getPayType().equals(payType)) continue;
            return value;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByLsValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getLsValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByUmpayValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getUmpayValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByLklValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getLklValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByYeepayValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getYeepayValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByXftValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getXftValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByFuiouValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getFuiouValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByJlValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getJlpayValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Integer getPayType() {
        return this.payType;
    }

    public String getLsValue() {
        return this.lsValue;
    }

    public String getUmpayValue() {
        return this.umpayValue;
    }

    public String getLklValue() {
        return this.lklValue;
    }

    public String getYeepayValue() {
        return this.yeepayValue;
    }

    public String getXftValue() {
        return this.xftValue;
    }

    public String getFuiouValue() {
        return this.fuiouValue;
    }

    public String getCcbValue() {
        return this.ccbValue;
    }

    public String getJlpayValue() {
        return this.jlpayValue;
    }
}

