/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.liquidationcore.facade.enums.fuiou;

import cn.hutool.core.collection.CollUtil;
import com.fshows.lifecircle.liquidationcore.facade.enums.common.TradeStateEnum;
import com.google.common.collect.Lists;
import java.util.List;

public enum FuiouTransStatEnum {
    SUCCESS("\u93b4\u612c\u59db", "SUCCESS", Lists.newArrayList((Object[])new String[]{"1"}), TradeStateEnum.TRADE_SUCCESS),
    PAY_ERROR("\u6fb6\u8fab\u89e6", "PAYERROR", Lists.newArrayList((Object[])new String[]{"5"}), TradeStateEnum.TRADE_FAIL),
    USER_PAYING("\u93c0\ue219\u7caf\u6d93\ufffd", "USERPAYING", Lists.newArrayList((Object[])new String[]{"6"}), TradeStateEnum.TRADE_PAYING),
    NOT_PAY("\u93c8\ue045\u656e\u6d60\ufffd", "NOTPAY", null, TradeStateEnum.TRADE_PAYING),
    CLOSED("\u5bb8\u63d2\u53e7\u95c2\ufffd", "CLOSED", null, TradeStateEnum.TRADE_CLOSED),
    REVOKED("\u5bb8\u53c9\u6319\u95bf\ufffd", "REVOKED", Lists.newArrayList((Object[])new String[]{"3", "4"}), TradeStateEnum.TRADE_CANCELED),
    REFUND("\u5bb8\u67e5\ufffd\ufffd\u5a06\ufffd", "REFUND", Lists.newArrayList((Object[])new String[]{"2"}), TradeStateEnum.REFUND_SUCCESS);

    private final String name;
    private final String value;
    private final List<String> bankPayValueList;
    private final TradeStateEnum tradeStateEnum;

    private FuiouTransStatEnum(String name, String value, List<String> bankPayValueList, TradeStateEnum tradeStateEnum) {
        this.name = name;
        this.value = value;
        this.bankPayValueList = bankPayValueList;
        this.tradeStateEnum = tradeStateEnum;
    }

    public static FuiouTransStatEnum getByValue(String value) {
        for (FuiouTransStatEnum v : FuiouTransStatEnum.values()) {
            if (!v.getValue().equalsIgnoreCase(value)) continue;
            return v;
        }
        return null;
    }

    public static FuiouTransStatEnum getByBankPayValue(String bankPayValue) {
        for (FuiouTransStatEnum v : FuiouTransStatEnum.values()) {
            if (!CollUtil.isNotEmpty(v.getBankPayValueList()) || !v.getBankPayValueList().contains(bankPayValue)) continue;
            return v;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public List<String> getBankPayValueList() {
        return this.bankPayValueList;
    }

    public TradeStateEnum getTradeStateEnum() {
        return this.tradeStateEnum;
    }
}

