/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.liquidationcore.facade.enums.common;

import org.apache.commons.lang3.StringUtils;

public enum PayPlatformEnum {
    WECHAT("\u5fae\u4fe1", "WECHAT", 1, "WXZF", "2"),
    ALIPAY("\u652f\u4ed8\u5b9d", "ALIPAY", 2, "ZFBZF", "1"),
    UNIONPAY("\u94f6\u8054\u4e91\u95ea\u4ed8", "UNIONPAY", 5, "UPSMZF", "6"),
    POS("POS", "BANK_CARD", 9, "", "8"),
    DCEP("\u6570\u5b57\u4eba\u6c11\u5e01", "DCEP", 40, "", "16"),
    UNKNOW("\u672a\u77e5", "UNKNOW", null, "UNKNOW", "UNKNOW");

    private String name;
    private String value;
    private Integer payType;
    private String lsValue;
    private String umpayValue;

    private PayPlatformEnum(String name, String value, Integer payType, String lsValue, String umpayValue) {
        this.name = name;
        this.value = value;
        this.payType = payType;
        this.lsValue = lsValue;
        this.umpayValue = umpayValue;
    }

    public static PayPlatformEnum getByValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByLsValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getLsValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public static PayPlatformEnum getByUmpayValue(String value) {
        PayPlatformEnum[] valueList;
        for (PayPlatformEnum v : valueList = PayPlatformEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)v.getUmpayValue(), (CharSequence)value)) continue;
            return v;
        }
        return UNKNOW;
    }

    public boolean matches(String value) {
        return StringUtils.isBlank((CharSequence)value) ? false : this.value.equals(value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getLsValue() {
        return this.lsValue;
    }

    public String getUmpayValue() {
        return this.umpayValue;
    }

    public Integer getPayType() {
        return this.payType;
    }
}

