/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.iotcore.facade.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum PayTypeEnum {
    WECHAT_PAY("\u5fae\u4fe1", Arrays.asList(1, 11, 12, 13), "/data/image/NewWxPay.png", "/app/wxLogoGrey.png"),
    ALIPAY_PAY("\u652f\u4ed8\u5b9d", Arrays.asList(2, 7, 21, 22, 23, 24), "/data/image/NewAliPay.png", "/app/alipayLogoGrey.png"),
    UNION_PAY("\u94f6\u8054", Collections.singletonList(5), "/data/image/NewUnionPay.png", "/app/unionLogoGrey.png"),
    BANKCARD_PAY("\u94f6\u884c\u5361", Arrays.asList(9, 91), "/data/image/NewCardPay.png", "/app/cardLogoGrey.png"),
    ALL("\u5168\u90e8", Arrays.asList(1, 11, 12, 13, 2, 7, 21, 22, 23, 24, 5, 9, 91), "", "");

    private final String name;
    private final List<Integer> value;
    private final String icon;
    private final String greyIcon;

    private PayTypeEnum(String name, List<Integer> value, String icon, String greyIcon) {
        this.name = name;
        this.value = value;
        this.icon = icon;
        this.greyIcon = greyIcon;
    }

    public static PayTypeEnum getByValue(Integer value) {
        PayTypeEnum[] valueList;
        for (PayTypeEnum v : valueList = PayTypeEnum.values()) {
            if (!v.getValue().contains(value)) continue;
            return v;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public List<Integer> getValue() {
        return this.value;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getGreyIcon() {
        return this.greyIcon;
    }
}

