/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.hardwarecore.facade.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum BackStockTypeEnum {
    MAINTAIN(1, "\u7ef4\u4fee"),
    RETURN(2, "\u9000\u8d27"),
    BACK(3, "\u56de\u5e93"),
    EXCHANGE(5, "\u6362\u8d27");

    private Integer code;
    private String name;
    public static final Map<Integer, String> backTypeMap;

    private BackStockTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static BackStockTypeEnum getByCode(Integer code) {
        BackStockTypeEnum[] valueList;
        for (BackStockTypeEnum v : valueList = BackStockTypeEnum.values()) {
            if (!v.getCode().equals(code)) continue;
            return v;
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    static {
        backTypeMap = Maps.newHashMap();
        backTypeMap.put(MAINTAIN.getCode(), MAINTAIN.getName());
        backTypeMap.put(RETURN.getCode(), RETURN.getName());
        backTypeMap.put(BACK.getCode(), BACK.getName());
        backTypeMap.put(EXCHANGE.getCode(), EXCHANGE.getName());
    }
}

