/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.datacore.facade.enums.newbill;

import cn.hutool.core.collection.CollectionUtil;
import com.beust.jcommander.internal.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum NewDisplayPayTypeEnum {
    WECHAT_PAY(1, "\u5fae\u4fe1", Arrays.asList(1, 11, 12, 13)),
    ALIPAY_PAY(2, "\u652f\u4ed8\u5b9d", Arrays.asList(2, 7, 21, 22, 23, 24, 25)),
    UNION_PAY(5, "\u4e91\u95ea\u4ed8", Collections.singletonList(5)),
    BANKCARD_PAY(9, "\u94f6\u884c\u5361", Arrays.asList(9, 91)),
    PREPAY_PAY(31, "\u9884\u4ed8\u5361", Collections.singletonList(31)),
    COUPON_PAY(32, "\u4f18\u60e0\u5238", Collections.singletonList(32)),
    ALIPAY_PREPAY_CARD(33, "\u652f\u4ed8\u5b9d\u9884\u4ed8\u5361", Collections.singletonList(33)),
    DCEP_PAY(40, "\u6570\u5b57\u4eba\u6c11\u5e01", Collections.singletonList(40)),
    DY_PAY(41, "\u6296\u97f3\u652f\u4ed8", Collections.singletonList(41));

    private final String name;
    private final Integer displayPayType;
    private final List<Integer> payTypes;

    private NewDisplayPayTypeEnum(Integer displayPayType, String name, List<Integer> payTypes) {
        this.name = name;
        this.displayPayType = displayPayType;
        this.payTypes = payTypes;
    }

    public static NewDisplayPayTypeEnum getByDisplayPayType(Integer displayPayType) {
        NewDisplayPayTypeEnum[] valueList;
        for (NewDisplayPayTypeEnum v : valueList = NewDisplayPayTypeEnum.values()) {
            if (!v.getDisplayPayType().equals(displayPayType)) continue;
            return v;
        }
        return null;
    }

    public static NewDisplayPayTypeEnum getByDisplayEnumName(String displayEnumName) {
        NewDisplayPayTypeEnum[] valueList;
        for (NewDisplayPayTypeEnum v : valueList = NewDisplayPayTypeEnum.values()) {
            if (!v.name().equals(displayEnumName)) continue;
            return v;
        }
        return null;
    }

    public static NewDisplayPayTypeEnum getByOriginalPayType(Integer payType) {
        NewDisplayPayTypeEnum[] valueList;
        for (NewDisplayPayTypeEnum v : valueList = NewDisplayPayTypeEnum.values()) {
            if (!v.getPayTypes().contains(payType)) continue;
            return v;
        }
        return null;
    }

    public static List<Integer> convertToOriginalPayTypeList(List<Integer> displayPayTypeList) {
        if (CollectionUtil.isNotEmpty(displayPayTypeList)) {
            List payTypeList = Lists.newArrayList();
            displayPayTypeList.forEach(displayPayType -> {
                NewDisplayPayTypeEnum displayPayTypeEnum = NewDisplayPayTypeEnum.getByDisplayPayType(displayPayType);
                if (displayPayTypeEnum != null) {
                    payTypeList.addAll(displayPayTypeEnum.getPayTypes());
                }
            });
            return payTypeList;
        }
        return null;
    }

    public static List<Integer> convertToOriginalPayTypeListByDisplayEnumName(List<String> displayEnumNameList) {
        if (CollectionUtil.isNotEmpty(displayEnumNameList)) {
            List payTypeList = Lists.newArrayList();
            displayEnumNameList.forEach(displayPayType -> {
                NewDisplayPayTypeEnum displayPayTypeEnum = NewDisplayPayTypeEnum.getByDisplayEnumName(displayPayType);
                if (displayPayTypeEnum != null) {
                    payTypeList.addAll(displayPayTypeEnum.getPayTypes());
                }
            });
            return payTypeList;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Integer getDisplayPayType() {
        return this.displayPayType;
    }

    public List<Integer> getPayTypes() {
        return this.payTypes;
    }
}

