/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.datacore.facade.util;

import com.fshows.lifecircle.datacore.facade.enums.newbill.NewDisplayPayTypeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class NewBillConstants {
    public static List<Integer> getAppPayTypes() {
        ArrayList payTypes = Lists.newArrayList();
        payTypes.addAll(NewDisplayPayTypeEnum.WECHAT_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.ALIPAY_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.UNION_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.BANKCARD_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.PREPAY_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.DCEP_PAY.getPayTypes());
        return payTypes;
    }

    public static List<Integer> getAppWandaPayTypes() {
        ArrayList payTypes = Lists.newArrayList();
        payTypes.addAll(NewDisplayPayTypeEnum.WECHAT_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.ALIPAY_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.UNION_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.BANKCARD_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.PREPAY_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.COUPON_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.ALIPAY_PREPAY_CARD.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.DCEP_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.DY_PAY.getPayTypes());
        return payTypes;
    }

    public static List<Integer> getBlocAppPayTypes(boolean isWandaBloc) {
        ArrayList payTypes = Lists.newArrayList();
        payTypes.addAll(NewDisplayPayTypeEnum.WECHAT_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.ALIPAY_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.UNION_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.BANKCARD_PAY.getPayTypes());
        if (isWandaBloc) {
            payTypes.addAll(NewDisplayPayTypeEnum.DCEP_PAY.getPayTypes());
            payTypes.addAll(NewDisplayPayTypeEnum.ALIPAY_PREPAY_CARD.getPayTypes());
        }
        payTypes.addAll(NewDisplayPayTypeEnum.PREPAY_PAY.getPayTypes());
        return payTypes;
    }

    public static List<Integer> getMerchantAdminPayTypes() {
        ArrayList payTypes = Lists.newArrayList();
        payTypes.addAll(NewDisplayPayTypeEnum.WECHAT_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.ALIPAY_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.UNION_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.BANKCARD_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.PREPAY_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.COUPON_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.ALIPAY_PREPAY_CARD.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.DCEP_PAY.getPayTypes());
        payTypes.addAll(NewDisplayPayTypeEnum.DY_PAY.getPayTypes());
        return payTypes;
    }

    public static List<Integer> getMerchantBlocAdminPayTypes() {
        return NewDisplayPayTypeEnum.convertToOriginalPayTypeList(NewBillConstants.getMerchantBlocAdminDisplayPayTypes());
    }

    public static List<Integer> getMerchantBlocAdminDisplayPayTypes() {
        ArrayList payTypes = Lists.newArrayList();
        payTypes.add(NewDisplayPayTypeEnum.WECHAT_PAY.getDisplayPayType());
        payTypes.add(NewDisplayPayTypeEnum.ALIPAY_PAY.getDisplayPayType());
        payTypes.add(NewDisplayPayTypeEnum.UNION_PAY.getDisplayPayType());
        payTypes.add(NewDisplayPayTypeEnum.BANKCARD_PAY.getDisplayPayType());
        payTypes.add(NewDisplayPayTypeEnum.DY_PAY.getDisplayPayType());
        return payTypes;
    }

    public static List<Integer> getBlocAdminPayTypes(boolean isWandaBloc) {
        return NewDisplayPayTypeEnum.convertToOriginalPayTypeList(NewBillConstants.getBlocAdminDisplayPayTypes(isWandaBloc));
    }

    public static List<Integer> getBlocAdminDisplayPayTypes(boolean isWandaBloc) {
        ArrayList payTypes = Lists.newArrayList();
        payTypes.add(NewDisplayPayTypeEnum.WECHAT_PAY.getDisplayPayType());
        payTypes.add(NewDisplayPayTypeEnum.ALIPAY_PAY.getDisplayPayType());
        payTypes.add(NewDisplayPayTypeEnum.UNION_PAY.getDisplayPayType());
        payTypes.add(NewDisplayPayTypeEnum.BANKCARD_PAY.getDisplayPayType());
        payTypes.add(NewDisplayPayTypeEnum.ALIPAY_PREPAY_CARD.getDisplayPayType());
        payTypes.add(NewDisplayPayTypeEnum.PREPAY_PAY.getDisplayPayType());
        payTypes.add(NewDisplayPayTypeEnum.COUPON_PAY.getDisplayPayType());
        if (isWandaBloc) {
            payTypes.add(NewDisplayPayTypeEnum.DCEP_PAY.getDisplayPayType());
        }
        return payTypes;
    }
}

