/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.basecore.facade.domain.response.delivery.sf;

import com.fshows.lifecircle.basecore.facade.domain.response.delivery.sf.ResultCode;
import java.io.Serializable;

public class BaseResponse<T>
implements Serializable {
    private static final long serialVersionUID = 4355194523550430557L;
    private String errorCode;
    private String errorMsg;
    private T data;

    public static <T> BaseResponse<T> create() {
        return new BaseResponse<T>();
    }

    public static <T> BaseResponse<T> create(Integer code, String errorMsg, T data) {
        BaseResponse<T> baseResponse = new BaseResponse<T>();
        baseResponse.setErrorCode(String.valueOf(code));
        baseResponse.setErrorMsg(errorMsg);
        baseResponse.setData(data);
        return baseResponse;
    }

    public static <T> BaseResponse<T> success(T data) {
        BaseResponse<T> result = BaseResponse.create();
        result.setErrorCode(ResultCode.SUCCESS.getCode() + "");
        result.setData(data);
        return result;
    }

    public static <T> BaseResponse<T> error(ResultCode code) {
        BaseResponse<T> result = BaseResponse.create();
        result.setErrorCode(code.getCode() + "");
        result.setErrorMsg(code.getMsg());
        return result;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Boolean isSuccess() {
        return ResultCode.SUCCESS.getCode().equals(this.errorCode);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResponse)) {
            return false;
        }
        BaseResponse other = (BaseResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResponse(errorCode=" + this.getErrorCode() + ", errorMsg=" + this.getErrorMsg() + ", data=" + this.getData() + ")";
    }
}

