/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.authcore.common;

import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;

public class ApiPageModel<T>
implements Serializable {
    private static final long serialVersionUID = 2446288122634551228L;
    private Integer page;
    private Integer pageSize;
    private List<T> list;
    private long total;

    public ApiPageModel() {
        this.total = 0L;
        this.page = 1;
        this.pageSize = 10;
        this.list = Lists.newArrayList();
    }

    public ApiPageModel(int total, List<T> list) {
        this.total = total;
        this.list = list;
        if (null == list) {
            this.list = Lists.newArrayList();
        }
    }

    public ApiPageModel(int page, int pageSize, long total, List<T> returnDo) {
        this.page = page;
        this.pageSize = pageSize;
        this.total = total;
        this.list = returnDo;
    }

    public ApiPageModel(PageInfo pageInfo) {
        this.page = pageInfo.getPageNum();
        this.pageSize = pageInfo.getPageSize();
        this.total = pageInfo.getTotal();
        this.list = pageInfo.getList();
    }

    public ApiPageModel(PageInfo pageInfo, List<T> returnDo) {
        this.page = pageInfo.getPageNum();
        this.pageSize = pageInfo.getPageSize();
        this.total = pageInfo.getTotal();
        this.list = returnDo;
    }

    public static <T> ApiPageModel<T> newBasePageResult(int total, List<T> list) {
        return new ApiPageModel<T>(total, list);
    }

    public Integer getPage() {
        return this.page;
    }

    public ApiPageModel<T> setPage(Integer page) {
        this.page = page;
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public ApiPageModel<T> setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }
}

