/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.authcore.result;

import java.io.Serializable;

public class ApiResult<T>
implements Serializable {
    private static final long serialVersionUID = -2547026529446900321L;
    private boolean success;
    private T data;
    private String errorCode;
    private String errorMsg;

    public ApiResult() {
    }

    public static ApiResult success() {
        return new ApiResult<String>(true, "\u64cd\u4f5c\u6210\u529f", "2000", "");
    }

    public static <T> ApiResult<T> success(T data) {
        return new ApiResult<T>(true, data, "2000", "");
    }

    public static <T> ApiResult<T> error(String errorCode, String errorMsg) {
        return new ApiResult<Object>(false, null, errorCode, errorMsg);
    }

    public ApiResult<T> data(T data) {
        this.success = true;
        this.data = data;
        this.errorCode = "2000";
        this.errorMsg = "";
        return this;
    }

    public ApiResult fail(String errorCode, String errorMsg) {
        this.success = false;
        this.data = null;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        return this;
    }

    public ApiResult(boolean success, T data, String errorCode, String errorMsg) {
        this.success = success;
        this.data = data;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public T getData() {
        return this.data;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResult)) {
            return false;
        }
        ApiResult other = (ApiResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        return !(this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        return result;
    }

    public String toString() {
        return "ApiResult(success=" + this.isSuccess() + ", data=" + this.getData() + ", errorCode=" + this.getErrorCode() + ", errorMsg=" + this.getErrorMsg() + ")";
    }
}

