/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.acctbizcore.facade.enums.exception;

import com.fshows.fsframework.common.exception.FsInternalException;
import com.fshows.lifecircle.acctbizcore.facade.constants.AccountConstant;
import com.fshows.lifecircle.acctbizcore.facade.enums.exception.base.ErrorCodeEnum;

public enum SystemErrorEnum {
    SYSTEM_ERROR(ErrorCodeEnum.SYS_ERROR, "\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"),
    REQUEST_METHOD_INVALID(ErrorCodeEnum.REQUEST_DATA_INVALID, "\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u652f\u6301"),
    CONTENT_TYPE_NOT_SUPPORTED(ErrorCodeEnum.REQUEST_DATA_INVALID, "\u8bf7\u6c42\u7684Content-Type\u4e0d\u652f\u6301"),
    REQUEST_ID_BLANK(ErrorCodeEnum.REQUEST_DATA_INVALID, "request_id\u4e0d\u80fd\u4e3a\u7a7a"),
    CONTENT_BLANK(ErrorCodeEnum.REQUEST_DATA_INVALID, "content\u4e0d\u80fd\u4e3a\u7a7a"),
    API_PARAM_FORMAT_INVALID(ErrorCodeEnum.REQUEST_DATA_INVALID, "\u63a5\u53e3\u53c2\u6570\u683c\u5f0f\u4e0d\u5408\u6cd5"),
    API_NOT_FOUND(ErrorCodeEnum.REQUEST_DATA_INVALID, "\u63a5\u53e3\u4e0d\u5b58\u5728"),
    SERVICE_BEAN_NOT_FOUND(ErrorCodeEnum.INNER_HANDLE_ERROR, "\u8bf7\u6c42\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728"),
    SERVICE_INIT_ERROR(ErrorCodeEnum.INNER_HANDLE_ERROR, "\u521d\u59cb\u5316\u5931\u8d25");

    private final ErrorCodeEnum code;
    private final String msg;

    private SystemErrorEnum(ErrorCodeEnum code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public ErrorCodeEnum getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public String subCode() {
        return this.code.getErrorBusinessType().getSubCodePrefix() + "." + this.name();
    }

    public FsInternalException exception() {
        return new FsInternalException(this.code.getErrorCode(), this.subCode(), this.msg).init(AccountConstant.EXCEPTION_PROJECT_ID, this.code.getErrorBusinessType().getBusinessType());
    }

    public FsInternalException exception(String msg) {
        return new FsInternalException(this.code.getErrorCode(), this.subCode(), msg).init(AccountConstant.EXCEPTION_PROJECT_ID, this.code.getErrorBusinessType().getBusinessType());
    }
}

