/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.accountcore.facade.enums.bankchannel;

import com.google.common.collect.Lists;
import java.util.List;

public enum BankChannelTransferStatusEnum {
    NOT_TRANSFER("\u672a\u8f6c\u8d26", "NOT_TRANSFER", "", Lists.newArrayList()),
    TRANSFER_PROCESSING("\u8f6c\u8d26\u4e2d", "TRANSFER_PROCESSING", "processing", Lists.newArrayList((Object[])new String[]{"0", "3"})),
    TRANSFER_SUCCESS("\u8f6c\u8d26\u6210\u529f", "TRANSFER_SUCCESS", "succeeded", Lists.newArrayList((Object[])new String[]{"1"})),
    TRANSFER_FAIL("\u8f6c\u8d26\u5931\u8d25", "TRANSFER_FAIL", "failed", Lists.newArrayList((Object[])new String[]{"2"})),
    PARTIALLY_SUCCEEDED("\u90e8\u5206\u6210\u529f", "PARTIALLY_SUCCEEDED", "partially_succeeded", Lists.newArrayList());

    private String name;
    private String value;
    private String transferStatus;
    private List<String> umpayStatus;

    private BankChannelTransferStatusEnum(String name, String value, String transferStatus, List<String> umpayStatus) {
        this.name = name;
        this.value = value;
        this.transferStatus = transferStatus;
        this.umpayStatus = umpayStatus;
    }

    public static BankChannelTransferStatusEnum getByValue(String value) {
        BankChannelTransferStatusEnum[] valueList;
        for (BankChannelTransferStatusEnum v : valueList = BankChannelTransferStatusEnum.values()) {
            if (!v.getValue().equals(value)) continue;
            return v;
        }
        return null;
    }

    public static BankChannelTransferStatusEnum getByTransferStatus(String transferStatus) {
        BankChannelTransferStatusEnum[] valueList;
        for (BankChannelTransferStatusEnum v : valueList = BankChannelTransferStatusEnum.values()) {
            if (!v.getTransferStatus().equals(transferStatus)) continue;
            return v;
        }
        return null;
    }

    public static BankChannelTransferStatusEnum getByUmpayStatus(String umpayStatus) {
        BankChannelTransferStatusEnum[] valueList;
        for (BankChannelTransferStatusEnum v : valueList = BankChannelTransferStatusEnum.values()) {
            if (!v.getUmpayStatus().contains(umpayStatus)) continue;
            return v;
        }
        return null;
    }

    public static boolean isTransferProcessing(String value) {
        return TRANSFER_PROCESSING.getValue().equals(value);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getTransferStatus() {
        return this.transferStatus;
    }

    public List<String> getUmpayStatus() {
        return this.umpayStatus;
    }
}

