/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.accountcore.facade.enums.bankchannel;

import com.google.common.collect.Lists;
import java.util.List;

public enum BankChannelWithdrawStatusEnum {
    NOT_WITHDRAW("\u672a\u63d0\u73b0", "NOT_WITHDRAW", "", Lists.newArrayList()),
    WITHDRAW_PROCESSING("\u63d0\u73b0\u4e2d", "WITHDRAW_PROCESSING", "processing", Lists.newArrayList((Object[])new String[]{"3", "4"})),
    WITHDRAW_SUCCESS("\u63d0\u73b0\u6210\u529f", "WITHDRAW_SUCCESS", "succeeded", Lists.newArrayList((Object[])new String[]{"1"})),
    WITHDRAW_FAIL("\u63d0\u73b0\u5931\u8d25", "WITHDRAW_FAIL", "failed", Lists.newArrayList((Object[])new String[]{"2"})),
    WITHDRAW_REFUND_TICKET("\u9000\u7968", "WITHDRAW_REFUND_TICKET", "refundTicket", Lists.newArrayList((Object[])new String[]{"5"}));

    private String name;
    private String value;
    private String withdrawStatus;
    private List<String> umpayStatus;

    private BankChannelWithdrawStatusEnum(String name, String value, String withdrawStatus, List<String> umpayStatus) {
        this.name = name;
        this.value = value;
        this.withdrawStatus = withdrawStatus;
        this.umpayStatus = umpayStatus;
    }

    public static boolean unWithdrawFailOrRefundTicket(String value) {
        return WITHDRAW_FAIL.getValue().equals(value) || WITHDRAW_REFUND_TICKET.getValue().equals(value);
    }

    public static BankChannelWithdrawStatusEnum getByValue(String value) {
        BankChannelWithdrawStatusEnum[] valueList;
        for (BankChannelWithdrawStatusEnum v : valueList = BankChannelWithdrawStatusEnum.values()) {
            if (!v.getValue().equals(value)) continue;
            return v;
        }
        return null;
    }

    public static BankChannelWithdrawStatusEnum getByWithdrawStatus(String withdrawStatus) {
        BankChannelWithdrawStatusEnum[] valueList;
        for (BankChannelWithdrawStatusEnum v : valueList = BankChannelWithdrawStatusEnum.values()) {
            if (!v.getWithdrawStatus().equals(withdrawStatus)) continue;
            return v;
        }
        return null;
    }

    public static BankChannelWithdrawStatusEnum getByUmpayStatus(String umpayStatus) {
        BankChannelWithdrawStatusEnum[] valueList;
        for (BankChannelWithdrawStatusEnum v : valueList = BankChannelWithdrawStatusEnum.values()) {
            if (!v.getUmpayStatus().contains(umpayStatus)) continue;
            return v;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getWithdrawStatus() {
        return this.withdrawStatus;
    }

    public List<String> getUmpayStatus() {
        return this.umpayStatus;
    }
}

