/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.accountcore.facade.enums;

import cn.hutool.core.util.ObjectUtil;

public enum LiquidationTypeEnum {
    LESHUA_WX("\u4e50\u5237", 2, null),
    SXPAY_WX("\u968f\u884c\u4ed8", 6, null),
    HFPAY_WX("\u6c47\u4ed8", 9, null),
    SHANDE_WX("\u6749\u5fb7", 12, null),
    VBILL_WX("\u968f\u884c\u4ed8\u76f4\u8fde", 15, null),
    DIRECT_LESHUA_WX("\u4e50\u5237\u76f4\u8fde", 21, null),
    UMPAY_WX("\u8054\u52a8", 26, null),
    LAKALA_WX("\u62c9\u5361\u62c9", 34, null),
    SHANDE_CLOUD_DIRECT("\u6749\u5fb7\u4e91\u76f4\u901a", 35, 1),
    UMPAY_CLOUD_DIRECT("\u8054\u52a8\u4e91\u76f4\u901a", 36, 2),
    YEEPAY_WX("\u6613\u5b9d\u5fae\u4fe1", 38, null),
    FUIOU_WX("\u5bcc\u53cb\u5fae\u4fe1", 47, null),
    EASY_PAY_WX("\u6613\u751f\u5fae\u4fe1", 55, null);

    private String name;
    private Integer value;
    private Integer bankChannel;

    private LiquidationTypeEnum(String name, Integer value, Integer bankChannel) {
        this.name = name;
        this.value = value;
        this.bankChannel = bankChannel;
    }

    public static LiquidationTypeEnum getByValue(Integer value) {
        LiquidationTypeEnum[] valueList;
        for (LiquidationTypeEnum v : valueList = LiquidationTypeEnum.values()) {
            if (!v.getValue().equals(value)) continue;
            return v;
        }
        return null;
    }

    public static Integer getLiquidationTypeByBankChannel(Integer bankChannel) {
        LiquidationTypeEnum[] valueList;
        for (LiquidationTypeEnum v : valueList = LiquidationTypeEnum.values()) {
            if (!ObjectUtil.isNotNull((Object)v.getBankChannel()) || !v.getBankChannel().equals(bankChannel)) continue;
            return v.getValue();
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public Integer getValue() {
        return this.value;
    }

    public Integer getBankChannel() {
        return this.bankChannel;
    }
}

