/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.client.impl;

import com.fshows.leshuapay.sdk.client.LeshuaPayClient;
import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.pay.LeshuaBasePayRequest;
import com.fshows.leshuapay.sdk.response.pay.LeshuaBasePayResponse;
import com.fshows.leshuapay.sdk.util.FsHttpUtil;
import com.fshows.leshuapay.sdk.util.LeshuaSignature;
import com.fshows.leshuapay.sdk.util.LeshuaUtils;
import com.fshows.leshuapay.sdk.util.RandomStringGenerator;
import com.fshows.leshuapay.sdk.util.ValidateUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshuaPayClientImpl<Req extends LeshuaBasePayRequest, Res extends LeshuaBasePayResponse>
implements LeshuaPayClient<Req, Res> {
    private static final Logger log = LoggerFactory.getLogger(LeshuaPayClientImpl.class);
    private static final String LESHUA = "leshua";
    private static final String XML_SIGN = "<sign>";
    private String apiKey;
    private String payServerUrl;
    private Integer timeout = 10000;
    private FsHttpUtil httpClientHelper = new FsHttpUtil();

    public LeshuaPayClientImpl(String apiKey, String payServerUrl) {
        this.apiKey = apiKey;
        this.payServerUrl = payServerUrl;
    }

    public LeshuaPayClientImpl(String apiKey, String payServerUrl, Integer timeout) {
        this.apiKey = apiKey;
        this.payServerUrl = payServerUrl;
        this.timeout = timeout;
    }

    @Override
    public Res execute(Req reqData, Class<Res> resClass) throws Exception {
        return this.execute(reqData, this.apiKey, this.payServerUrl, resClass, this.timeout);
    }

    @Override
    public Res execute(Req reqData, Class<Res> resClass, Integer timeout) throws Exception {
        return this.execute(reqData, this.apiKey, this.payServerUrl, resClass, timeout);
    }

    @Override
    public Res execute(Req reqData, String apiKey, String payServerUrl, Class<Res> resClass, Integer timeout) throws Exception {
        ValidateUtil.validateWithThrow(reqData, new Class[0]);
        String respXml = this.request(payServerUrl, reqData, apiKey, true, timeout);
        return (Res)((LeshuaBasePayResponse)LeshuaUtils.getObjectFromXML(respXml, resClass, LESHUA));
    }

    private String request(String serviceUrl, Req request, String apiKey, boolean isCheckRespSign, Integer timeout) throws Exception {
        long costTimeStart = System.currentTimeMillis();
        String nonceStr = RandomStringGenerator.genUUIDString();
        Map<String, String> reqMap = LeshuaUtils.toMap(request);
        reqMap.put("nonce_str", nonceStr);
        String sign = LeshuaSignature.getMD5Sign(reqMap, this.reqExcludedSignParams(), apiKey);
        reqMap.put("sign", sign);
        String respStr = this.httpClientHelper.postForm(serviceUrl, reqMap, "application/xml", timeout);
        long totalTimeCost = System.currentTimeMillis() - costTimeStart;
        log.info("\u8017\u65f6={}ms, request={}, response={}", new Object[]{totalTimeCost, reqMap, respStr});
        if (isCheckRespSign && null != respStr && respStr.contains(XML_SIGN) && !LeshuaSignature.checkIsSignValidFromResponseString(respStr, this.resExcludedSignParams(), apiKey)) {
            log.error("\u9a8c\u7b7e\u5931\u8d25,request={}", request);
            throw new LeshuaException("\u9a8c\u7b7e\u5931\u8d25");
        }
        return respStr;
    }

    private Set<String> reqExcludedSignParams() {
        HashSet<String> excludedSignParams = new HashSet<String>(1);
        excludedSignParams.add("sign");
        return excludedSignParams;
    }

    private Set<String> resExcludedSignParams() {
        HashSet<String> excludedSignParams = new HashSet<String>(2);
        excludedSignParams.add("sign");
        excludedSignParams.add("resp_code");
        return excludedSignParams;
    }

    private LeshuaPayClientImpl() {
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getPayServerUrl() {
        return this.payServerUrl;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public FsHttpUtil getHttpClientHelper() {
        return this.httpClientHelper;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setPayServerUrl(String payServerUrl) {
        this.payServerUrl = payServerUrl;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setHttpClientHelper(FsHttpUtil httpClientHelper) {
        this.httpClientHelper = httpClientHelper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeshuaPayClientImpl)) {
            return false;
        }
        LeshuaPayClientImpl other = (LeshuaPayClientImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$payServerUrl = this.getPayServerUrl();
        String other$payServerUrl = other.getPayServerUrl();
        if (this$payServerUrl == null ? other$payServerUrl != null : !this$payServerUrl.equals(other$payServerUrl)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        FsHttpUtil this$httpClientHelper = this.getHttpClientHelper();
        FsHttpUtil other$httpClientHelper = other.getHttpClientHelper();
        return !(this$httpClientHelper == null ? other$httpClientHelper != null : !this$httpClientHelper.equals(other$httpClientHelper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeshuaPayClientImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $payServerUrl = this.getPayServerUrl();
        result = result * 59 + ($payServerUrl == null ? 43 : $payServerUrl.hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        FsHttpUtil $httpClientHelper = this.getHttpClientHelper();
        result = result * 59 + ($httpClientHelper == null ? 43 : $httpClientHelper.hashCode());
        return result;
    }

    public String toString() {
        return "LeshuaPayClientImpl(apiKey=" + this.getApiKey() + ", payServerUrl=" + this.getPayServerUrl() + ", timeout=" + this.getTimeout() + ", httpClientHelper=" + this.getHttpClientHelper() + ")";
    }
}

