/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.share;

import lombok.Data;

import java.io.Serializable;

/**
 * 分账详情
 *
 * @author linzy
 * @version RoyaltyDetails.java, v 0.1 2021-05-14 11:50 linzy
 */
@Data
public class RoyaltyDetails implements Serializable {

    private static final long serialVersionUID = 2564332514461824401L;

    /**
     * 分账商户号
     */
    private String accountId;

    /**
     * 分账金额，单位（分）
     */
    private String amount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 分账明细类型，0：分账，1：撤销
     */
    private String tradeType;
}
