/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.MerchantNolegaSigQueryResponse;
import com.fshows.leshuapay.sdk.response.merchant.MerchantNolegaSignApplyResponse;
import lombok.Data;

/**
 *
 *
 * @author weikunpeng
 * @version MerchantNolegaSignQueryRequest.java, v 0.1 2025-08-07 15:53 weikunpeng
 */
@Data
public class MerchantNolegaSignQueryRequest extends LeshuaBizRequest<MerchantNolegaSigQueryResponse> {

    /**
     * 乐刷商户号
     */
    private String merchantId;

    /**
     * 合同签署编号，必填
     */
    private String contractId;


    @Override
    public Class<MerchantNolegaSigQueryResponse> getResponseClass() {
        return MerchantNolegaSigQueryResponse.class;
    }
}